package io.logicdrop.openapi.spring.api;

import io.logicdrop.openapi.spring.ApiClient;

import java.io.File;
import io.logicdrop.openapi.spring.models.FileResult;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.spring.api.ContentServicesApi")
public class ContentServicesApi {
    private ApiClient apiClient;

    public ContentServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete content
     * Delete a file in content
     * <p><b>200</b> - The deleted files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> deleteContent(String client, String folders, String filename, String extension) throws RestClientException {
        return deleteContentWithHttpInfo(client, folders, filename, extension).getBody();
    }

    /**
     * Delete content
     * Delete a file in content
     * <p><b>200</b> - The deleted files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> deleteContentWithHttpInfo(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling deleteContent");
        }
        
        // verify the required parameter 'filename' is set
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling deleteContent");
        }
        
        // verify the required parameter 'extension' is set
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling deleteContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        uriVariables.put("filename", filename);
        uriVariables.put("extension", extension);
        String path = apiClient.expandPath("/content/{client}/{folders}/{filename}.{extension}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete private content
     * Delete a private file in content
     * <p><b>200</b> - The deleted files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> deletePrivateContent(String client, String folders, String filename, String extension) throws RestClientException {
        return deletePrivateContentWithHttpInfo(client, folders, filename, extension).getBody();
    }

    /**
     * Delete private content
     * Delete a private file in content
     * <p><b>200</b> - The deleted files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> deletePrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deletePrivateContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling deletePrivateContent");
        }
        
        // verify the required parameter 'filename' is set
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling deletePrivateContent");
        }
        
        // verify the required parameter 'extension' is set
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling deletePrivateContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        uriVariables.put("filename", filename);
        uriVariables.put("extension", extension);
        String path = apiClient.expandPath("/content/{client}/private/{folders}/{filename}.{extension}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get content
     * Get a file in content
     * <p><b>200</b> - The file
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String getContent(String client, String folders, String filename, String extension) throws RestClientException {
        return getContentWithHttpInfo(client, folders, filename, extension).getBody();
    }

    /**
     * Get content
     * Get a file in content
     * <p><b>200</b> - The file
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> getContentWithHttpInfo(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getContent");
        }
        
        // verify the required parameter 'filename' is set
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getContent");
        }
        
        // verify the required parameter 'extension' is set
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        uriVariables.put("filename", filename);
        uriVariables.put("extension", extension);
        String path = apiClient.expandPath("/content/{client}/{folders}/{filename}.{extension}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/octet-stream"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get private content
     * Get a private file in content
     * <p><b>200</b> - The file
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String getPrivateContent(String client, String folders, String filename, String extension) throws RestClientException {
        return getPrivateContentWithHttpInfo(client, folders, filename, extension).getBody();
    }

    /**
     * Get private content
     * Get a private file in content
     * <p><b>200</b> - The file
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> getPrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getPrivateContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getPrivateContent");
        }
        
        // verify the required parameter 'filename' is set
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getPrivateContent");
        }
        
        // verify the required parameter 'extension' is set
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getPrivateContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        uriVariables.put("filename", filename);
        uriVariables.put("extension", extension);
        String path = apiClient.expandPath("/content/{client}/private/{folders}/{filename}.{extension}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/octet-stream"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get signed token
     * Get a signed token for uploading or downloading directly
     * <p><b>200</b> - The signed url
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @param expires Expiration (optional)
     * @param _public Private or public origin (default false) (optional)
     * @param upload URL for uploading (optional)
     * @return FileResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public FileResult getSignedToken(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws RestClientException {
        return getSignedTokenWithHttpInfo(client, folders, filename, extension, expires, _public, upload).getBody();
    }

    /**
     * Get signed token
     * Get a signed token for uploading or downloading directly
     * <p><b>200</b> - The signed url
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param filename Filename (required)
     * @param extension Extension (required)
     * @param expires Expiration (optional)
     * @param _public Private or public origin (default false) (optional)
     * @param upload URL for uploading (optional)
     * @return ResponseEntity&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<FileResult> getSignedTokenWithHttpInfo(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getSignedToken");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getSignedToken");
        }
        
        // verify the required parameter 'filename' is set
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getSignedToken");
        }
        
        // verify the required parameter 'extension' is set
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getSignedToken");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        uriVariables.put("filename", filename);
        uriVariables.put("extension", extension);
        String path = apiClient.expandPath("/content/{client}/signed/{folders}/{filename}.{extension}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "expires", expires));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "public", _public));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "upload", upload));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<FileResult> returnType = new ParameterizedTypeReference<FileResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List contents
     * List files in content
     * <p><b>200</b> - The listed files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> listContent(String client, String folders) throws RestClientException {
        return listContentWithHttpInfo(client, folders).getBody();
    }

    /**
     * List contents
     * List files in content
     * <p><b>200</b> - The listed files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> listContentWithHttpInfo(String client, String folders) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling listContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        String path = apiClient.expandPath("/content/{client}/{folders}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List private contents
     * List private files in content
     * <p><b>200</b> - The listed files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param recursive Include subfolders (optional)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> listPrivateContent(String client, String folders, String recursive) throws RestClientException {
        return listPrivateContentWithHttpInfo(client, folders, recursive).getBody();
    }

    /**
     * List private contents
     * List private files in content
     * <p><b>200</b> - The listed files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param recursive Include subfolders (optional)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> listPrivateContentWithHttpInfo(String client, String folders, String recursive) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listPrivateContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling listPrivateContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        String path = apiClient.expandPath("/content/{client}/private/{folders}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "recursive", recursive));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload content
     * Upload file(s) to content
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param explode If a zip or folder, explode (optional)
     * @param unique Use unique names (optional)
     * @param file File (optional)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> uploadContent(String client, String folders, String explode, String unique, File file) throws RestClientException {
        return uploadContentWithHttpInfo(client, folders, explode, unique, file).getBody();
    }

    /**
     * Upload content
     * Upload file(s) to content
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param explode If a zip or folder, explode (optional)
     * @param unique Use unique names (optional)
     * @param file File (optional)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> uploadContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling uploadContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        String path = apiClient.expandPath("/content/{client}/{folders}/upload", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "explode", explode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "unique", unique));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload private content
     * Upload file(s) to content
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param explode If a zip or folder, explode (optional)
     * @param unique Use unique names (optional)
     * @param file File (optional)
     * @return List&lt;FileResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<FileResult> uploadPrivateContent(String client, String folders, String explode, String unique, File file) throws RestClientException {
        return uploadPrivateContentWithHttpInfo(client, folders, explode, unique, file).getBody();
    }

    /**
     * Upload private content
     * Upload file(s) to content
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param folders Folders (required)
     * @param explode If a zip or folder, explode (optional)
     * @param unique Use unique names (optional)
     * @param file File (optional)
     * @return ResponseEntity&lt;List&lt;FileResult&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<FileResult>> uploadPrivateContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadPrivateContent");
        }
        
        // verify the required parameter 'folders' is set
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling uploadPrivateContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("folders", folders);
        String path = apiClient.expandPath("/content/{client}/private/{folders}/upload", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "explode", explode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "unique", unique));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<FileResult>> returnType = new ParameterizedTypeReference<List<FileResult>>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
