/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * InlineResponse200StatusInfo
 */
@JsonPropertyOrder({
  InlineResponse200StatusInfo.JSON_PROPERTY_FAMILY,
  InlineResponse200StatusInfo.JSON_PROPERTY_REASON_PHRASE,
  InlineResponse200StatusInfo.JSON_PROPERTY_STATUS_CODE
})

public class InlineResponse200StatusInfo {
  /**
   * Gets or Sets family
   */
  public enum FamilyEnum {
    INFORMATIONAL("INFORMATIONAL"),
    
    SUCCESSFUL("SUCCESSFUL"),
    
    REDIRECTION("REDIRECTION"),
    
    CLIENT_ERROR("CLIENT_ERROR"),
    
    SERVER_ERROR("SERVER_ERROR"),
    
    OTHER("OTHER");

    private String value;

    FamilyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FamilyEnum fromValue(String value) {
      for (FamilyEnum b : FamilyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FAMILY = "family";
  private FamilyEnum family;

  public static final String JSON_PROPERTY_REASON_PHRASE = "reasonPhrase";
  private String reasonPhrase;

  public static final String JSON_PROPERTY_STATUS_CODE = "statusCode";
  private Integer statusCode;


  public InlineResponse200StatusInfo family(FamilyEnum family) {
    
    this.family = family;
    return this;
  }

   /**
   * Get family
   * @return family
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FamilyEnum getFamily() {
    return family;
  }


  public void setFamily(FamilyEnum family) {
    this.family = family;
  }


  public InlineResponse200StatusInfo reasonPhrase(String reasonPhrase) {
    
    this.reasonPhrase = reasonPhrase;
    return this;
  }

   /**
   * Get reasonPhrase
   * @return reasonPhrase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REASON_PHRASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReasonPhrase() {
    return reasonPhrase;
  }


  public void setReasonPhrase(String reasonPhrase) {
    this.reasonPhrase = reasonPhrase;
  }


  public InlineResponse200StatusInfo statusCode(Integer statusCode) {
    
    this.statusCode = statusCode;
    return this;
  }

   /**
   * Get statusCode
   * @return statusCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStatusCode() {
    return statusCode;
  }


  public void setStatusCode(Integer statusCode) {
    this.statusCode = statusCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200StatusInfo inlineResponse200StatusInfo = (InlineResponse200StatusInfo) o;
    return Objects.equals(this.family, inlineResponse200StatusInfo.family) &&
        Objects.equals(this.reasonPhrase, inlineResponse200StatusInfo.reasonPhrase) &&
        Objects.equals(this.statusCode, inlineResponse200StatusInfo.statusCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(family, reasonPhrase, statusCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200StatusInfo {\n");
    sb.append("    family: ").append(toIndentedString(family)).append("\n");
    sb.append("    reasonPhrase: ").append(toIndentedString(reasonPhrase)).append("\n");
    sb.append("    statusCode: ").append(toIndentedString(statusCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

