/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.models.ImportExportTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ExportRulesetRequest
 */
@JsonPropertyOrder({
  ExportRulesetRequest.JSON_PROPERTY_FILENAME,
  ExportRulesetRequest.JSON_PROPERTY_RULESET,
  ExportRulesetRequest.JSON_PROPERTY_VERSION,
  ExportRulesetRequest.JSON_PROPERTY_TARGET,
  ExportRulesetRequest.JSON_PROPERTY_OPTIONS
})

public class ExportRulesetRequest {
  public static final String JSON_PROPERTY_FILENAME = "filename";
  private String filename;

  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_TARGET = "target";
  private ImportExportTarget target;

  public static final String JSON_PROPERTY_OPTIONS = "options";
  private Object options;


  public ExportRulesetRequest filename(String filename) {
    
    this.filename = filename;
    return this;
  }

   /**
   * Alternative filename without extension
   * @return filename
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Alternative filename without extension")
  @JsonProperty(JSON_PROPERTY_FILENAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilename() {
    return filename;
  }


  public void setFilename(String filename) {
    this.filename = filename;
  }


  public ExportRulesetRequest ruleset(String ruleset) {
    
    this.ruleset = ruleset;
    return this;
  }

   /**
   * Ruleset to export
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset to export")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }


  public void setRuleset(String ruleset) {
    this.ruleset = ruleset;
  }


  public ExportRulesetRequest version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version to export
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Version to export")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public ExportRulesetRequest target(ImportExportTarget target) {
    
    this.target = target;
    return this;
  }

   /**
   * Get target
   * @return target
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ImportExportTarget getTarget() {
    return target;
  }


  public void setTarget(ImportExportTarget target) {
    this.target = target;
  }


  public ExportRulesetRequest options(Object options) {
    
    this.options = options;
    return this;
  }

   /**
   * Export options
   * @return options
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Export options")
  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getOptions() {
    return options;
  }


  public void setOptions(Object options) {
    this.options = options;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExportRulesetRequest exportRulesetRequest = (ExportRulesetRequest) o;
    return Objects.equals(this.filename, exportRulesetRequest.filename) &&
        Objects.equals(this.ruleset, exportRulesetRequest.ruleset) &&
        Objects.equals(this.version, exportRulesetRequest.version) &&
        Objects.equals(this.target, exportRulesetRequest.target) &&
        Objects.equals(this.options, exportRulesetRequest.options);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filename, ruleset, version, target, options);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExportRulesetRequest {\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

