/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.models.ProcessorPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Compute pipeline request
 */
@ApiModel(description = "Compute pipeline request")
@JsonPropertyOrder({
  ComputePipelineRequest.JSON_PROPERTY_ROUTE,
  ComputePipelineRequest.JSON_PROPERTY_PAYLOAD
})

public class ComputePipelineRequest {
  public static final String JSON_PROPERTY_ROUTE = "route";
  private String route;

  public static final String JSON_PROPERTY_PAYLOAD = "payload";
  private ProcessorPayload payload;


  public ComputePipelineRequest route(String route) {
    
    this.route = route;
    return this;
  }

   /**
   * Pipeline Route
   * @return route
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Pipeline Route")
  @JsonProperty(JSON_PROPERTY_ROUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoute() {
    return route;
  }


  public void setRoute(String route) {
    this.route = route;
  }


  public ComputePipelineRequest payload(ProcessorPayload payload) {
    
    this.payload = payload;
    return this;
  }

   /**
   * Get payload
   * @return payload
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYLOAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessorPayload getPayload() {
    return payload;
  }


  public void setPayload(ProcessorPayload payload) {
    this.payload = payload;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ComputePipelineRequest computePipelineRequest = (ComputePipelineRequest) o;
    return Objects.equals(this.route, computePipelineRequest.route) &&
        Objects.equals(this.payload, computePipelineRequest.payload);
  }

  @Override
  public int hashCode() {
    return Objects.hash(route, payload);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ComputePipelineRequest {\n");
    sb.append("    route: ").append(toIndentedString(route)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

