/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * BuildPipelineRequest
 */
@JsonPropertyOrder({
  BuildPipelineRequest.JSON_PROPERTY_CONTENT,
  BuildPipelineRequest.JSON_PROPERTY_CLIENT,
  BuildPipelineRequest.JSON_PROPERTY_DEPENDENCIES,
  BuildPipelineRequest.JSON_PROPERTY_FILENAME,
  BuildPipelineRequest.JSON_PROPERTY_NAME,
  BuildPipelineRequest.JSON_PROPERTY_PROJECT,
  BuildPipelineRequest.JSON_PROPERTY_PROPERTIES
})

public class BuildPipelineRequest {
  public static final String JSON_PROPERTY_CONTENT = "content";
  private String content;

  public static final String JSON_PROPERTY_CLIENT = "client";
  private String client;

  public static final String JSON_PROPERTY_DEPENDENCIES = "dependencies";
  private List<String> dependencies = null;

  public static final String JSON_PROPERTY_FILENAME = "filename";
  private String filename;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;


  public BuildPipelineRequest content(String content) {
    
    this.content = content;
    return this;
  }

   /**
   * Content body
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Content body")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContent() {
    return content;
  }


  public void setContent(String content) {
    this.content = content;
  }


  public BuildPipelineRequest client(String client) {
    
    this.client = client;
    return this;
  }

   /**
   * Client name
   * @return client
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Client name")
  @JsonProperty(JSON_PROPERTY_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClient() {
    return client;
  }


  public void setClient(String client) {
    this.client = client;
  }


  public BuildPipelineRequest dependencies(List<String> dependencies) {
    
    this.dependencies = dependencies;
    return this;
  }

  public BuildPipelineRequest addDependenciesItem(String dependenciesItem) {
    if (this.dependencies == null) {
      this.dependencies = new ArrayList<>();
    }
    this.dependencies.add(dependenciesItem);
    return this;
  }

   /**
   * List of dependencies to import
   * @return dependencies
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of dependencies to import")
  @JsonProperty(JSON_PROPERTY_DEPENDENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDependencies() {
    return dependencies;
  }


  public void setDependencies(List<String> dependencies) {
    this.dependencies = dependencies;
  }


  public BuildPipelineRequest filename(String filename) {
    
    this.filename = filename;
    return this;
  }

   /**
   * Filename to use
   * @return filename
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filename to use")
  @JsonProperty(JSON_PROPERTY_FILENAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilename() {
    return filename;
  }


  public void setFilename(String filename) {
    this.filename = filename;
  }


  public BuildPipelineRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of pipeline
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of pipeline")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public BuildPipelineRequest project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Name of project
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of project")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public BuildPipelineRequest properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public BuildPipelineRequest putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * Map of additional camel properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Map of additional camel properties")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BuildPipelineRequest buildPipelineRequest = (BuildPipelineRequest) o;
    return Objects.equals(this.content, buildPipelineRequest.content) &&
        Objects.equals(this.client, buildPipelineRequest.client) &&
        Objects.equals(this.dependencies, buildPipelineRequest.dependencies) &&
        Objects.equals(this.filename, buildPipelineRequest.filename) &&
        Objects.equals(this.name, buildPipelineRequest.name) &&
        Objects.equals(this.project, buildPipelineRequest.project) &&
        Objects.equals(this.properties, buildPipelineRequest.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content, client, dependencies, filename, name, project, properties);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BuildPipelineRequest {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    client: ").append(toIndentedString(client)).append("\n");
    sb.append("    dependencies: ").append(toIndentedString(dependencies)).append("\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

