/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ProcessorRouteRequestAllOf
 */
@JsonPropertyOrder({
  ProcessorRouteRequestAllOf.JSON_PROPERTY_ID,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_TIMESTAMP,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_PROPERTIES,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_ROUTE,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_DURATION,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_OPTIONS,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_INPUTS,
  ProcessorRouteRequestAllOf.JSON_PROPERTY_AT_TYPE
})

public class ProcessorRouteRequestAllOf {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_ROUTE = "route";
  private String route;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private Long duration;

  public static final String JSON_PROPERTY_OPTIONS = "options";
  private Object options;

  public static final String JSON_PROPERTY_INPUTS = "inputs";
  private List<Map<String, Object>> inputs = null;

  public static final String JSON_PROPERTY_AT_TYPE = "@type";
  private String atType = "ProcessorRouteRequest";


   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }




   /**
   * Get timestamp
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimestamp() {
    return timestamp;
  }




  public ProcessorRouteRequestAllOf properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public ProcessorRouteRequestAllOf putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public ProcessorRouteRequestAllOf route(String route) {
    
    this.route = route;
    return this;
  }

   /**
   * Get route
   * @return route
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoute() {
    return route;
  }


  public void setRoute(String route) {
    this.route = route;
  }


   /**
   * Get duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDuration() {
    return duration;
  }




  public ProcessorRouteRequestAllOf options(Object options) {
    
    this.options = options;
    return this;
  }

   /**
   * Get options
   * @return options
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getOptions() {
    return options;
  }


  public void setOptions(Object options) {
    this.options = options;
  }


  public ProcessorRouteRequestAllOf inputs(List<Map<String, Object>> inputs) {
    
    this.inputs = inputs;
    return this;
  }

  public ProcessorRouteRequestAllOf addInputsItem(Map<String, Object> inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

   /**
   * Inputs to process
   * @return inputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Inputs to process")
  @JsonProperty(JSON_PROPERTY_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Map<String, Object>> getInputs() {
    return inputs;
  }


  public void setInputs(List<Map<String, Object>> inputs) {
    this.inputs = inputs;
  }


   /**
   * Discriminator
   * @return atType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Discriminator")
  @JsonProperty(JSON_PROPERTY_AT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAtType() {
    return atType;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessorRouteRequestAllOf processorRouteRequestAllOf = (ProcessorRouteRequestAllOf) o;
    return Objects.equals(this.id, processorRouteRequestAllOf.id) &&
        Objects.equals(this.timestamp, processorRouteRequestAllOf.timestamp) &&
        Objects.equals(this.properties, processorRouteRequestAllOf.properties) &&
        Objects.equals(this.route, processorRouteRequestAllOf.route) &&
        Objects.equals(this.duration, processorRouteRequestAllOf.duration) &&
        Objects.equals(this.options, processorRouteRequestAllOf.options) &&
        Objects.equals(this.inputs, processorRouteRequestAllOf.inputs) &&
        Objects.equals(this.atType, processorRouteRequestAllOf.atType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, timestamp, properties, route, duration, options, inputs, atType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessorRouteRequestAllOf {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    route: ").append(toIndentedString(route)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    atType: ").append(toIndentedString(atType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

