/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ArtifactReference
 */
@JsonPropertyOrder({
  ArtifactReference.JSON_PROPERTY_ID,
  ArtifactReference.JSON_PROPERTY_ARTIFACT,
  ArtifactReference.JSON_PROPERTY_VERSION,
  ArtifactReference.JSON_PROPERTY_NAME,
  ArtifactReference.JSON_PROPERTY_PATH,
  ArtifactReference.JSON_PROPERTY_URL,
  ArtifactReference.JSON_PROPERTY_DESCRIPTION,
  ArtifactReference.JSON_PROPERTY_TAGS,
  ArtifactReference.JSON_PROPERTY_PROPERTIES
})

public class ArtifactReference {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ARTIFACT = "artifact";
  private String artifact;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<String> tags = null;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;


  public ArtifactReference id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Artifact ID
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Artifact ID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public ArtifactReference artifact(String artifact) {
    
    this.artifact = artifact;
    return this;
  }

   /**
   * Name
   * @return artifact
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name")
  @JsonProperty(JSON_PROPERTY_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArtifact() {
    return artifact;
  }


  public void setArtifact(String artifact) {
    this.artifact = artifact;
  }


  public ArtifactReference version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public ArtifactReference name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Display name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Display name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public ArtifactReference path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * Service path
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Service path")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


   /**
   * URL
   * @return url
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "URL")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }




  public ArtifactReference description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Description")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public ArtifactReference tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ArtifactReference addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Tags")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public ArtifactReference properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public ArtifactReference putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArtifactReference artifactReference = (ArtifactReference) o;
    return Objects.equals(this.id, artifactReference.id) &&
        Objects.equals(this.artifact, artifactReference.artifact) &&
        Objects.equals(this.version, artifactReference.version) &&
        Objects.equals(this.name, artifactReference.name) &&
        Objects.equals(this.path, artifactReference.path) &&
        Objects.equals(this.url, artifactReference.url) &&
        Objects.equals(this.description, artifactReference.description) &&
        Objects.equals(this.tags, artifactReference.tags) &&
        Objects.equals(this.properties, artifactReference.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, artifact, version, name, path, url, description, tags, properties);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArtifactReference {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    artifact: ").append(toIndentedString(artifact)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

