/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * RuleContainer
 */
@JsonPropertyOrder({
  RuleContainer.JSON_PROPERTY_CLIENT,
  RuleContainer.JSON_PROPERTY_PROJECT,
  RuleContainer.JSON_PROPERTY_RULESET,
  RuleContainer.JSON_PROPERTY_DISPLAY,
  RuleContainer.JSON_PROPERTY_VERSION,
  RuleContainer.JSON_PROPERTY_DESCRIPTION,
  RuleContainer.JSON_PROPERTY_STATUS,
  RuleContainer.JSON_PROPERTY_PUBLISHED,
  RuleContainer.JSON_PROPERTY_STOPPED,
  RuleContainer.JSON_PROPERTY_UPTIME,
  RuleContainer.JSON_PROPERTY_MESSAGE
})

public class RuleContainer {
  public static final String JSON_PROPERTY_CLIENT = "client";
  private String client;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_DISPLAY = "display";
  private String display;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    RUNNING("RUNNING"),
    
    STOPPED("STOPPED"),
    
    ERROR("ERROR");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_PUBLISHED = "published";
  private OffsetDateTime published;

  public static final String JSON_PROPERTY_STOPPED = "stopped";
  private OffsetDateTime stopped;

  public static final String JSON_PROPERTY_UPTIME = "uptime";
  private String uptime;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;


   /**
   * Get client
   * @return client
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClient() {
    return client;
  }




  public RuleContainer project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Get project
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public RuleContainer ruleset(String ruleset) {
    
    this.ruleset = ruleset;
    return this;
  }

   /**
   * Get ruleset
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }


  public void setRuleset(String ruleset) {
    this.ruleset = ruleset;
  }


   /**
   * Get display
   * @return display
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplay() {
    return display;
  }




  public RuleContainer version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }




   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }




   /**
   * Get published
   * @return published
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getPublished() {
    return published;
  }




   /**
   * Get stopped
   * @return stopped
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STOPPED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStopped() {
    return stopped;
  }




   /**
   * Get uptime
   * @return uptime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPTIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUptime() {
    return uptime;
  }




   /**
   * Get message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RuleContainer ruleContainer = (RuleContainer) o;
    return Objects.equals(this.client, ruleContainer.client) &&
        Objects.equals(this.project, ruleContainer.project) &&
        Objects.equals(this.ruleset, ruleContainer.ruleset) &&
        Objects.equals(this.display, ruleContainer.display) &&
        Objects.equals(this.version, ruleContainer.version) &&
        Objects.equals(this.description, ruleContainer.description) &&
        Objects.equals(this.status, ruleContainer.status) &&
        Objects.equals(this.published, ruleContainer.published) &&
        Objects.equals(this.stopped, ruleContainer.stopped) &&
        Objects.equals(this.uptime, ruleContainer.uptime) &&
        Objects.equals(this.message, ruleContainer.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(client, project, ruleset, display, version, description, status, published, stopped, uptime, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RuleContainer {\n");
    sb.append("    client: ").append(toIndentedString(client)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    display: ").append(toIndentedString(display)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    published: ").append(toIndentedString(published)).append("\n");
    sb.append("    stopped: ").append(toIndentedString(stopped)).append("\n");
    sb.append("    uptime: ").append(toIndentedString(uptime)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

