/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ActivateRulesetResponse
 */
@JsonPropertyOrder({
  ActivateRulesetResponse.JSON_PROPERTY_CLIENT,
  ActivateRulesetResponse.JSON_PROPERTY_PROJECT,
  ActivateRulesetResponse.JSON_PROPERTY_RULESET,
  ActivateRulesetResponse.JSON_PROPERTY_VERSION,
  ActivateRulesetResponse.JSON_PROPERTY_ACTIVE
})

public class ActivateRulesetResponse {
  public static final String JSON_PROPERTY_CLIENT = "client";
  private String client;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;


   /**
   * Client name
   * @return client
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Client name")
  @JsonProperty(JSON_PROPERTY_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClient() {
    return client;
  }




   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }




   /**
   * Ruleset name
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset name")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }




   /**
   * Version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }




   /**
   * Is the ruleset active?
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Is the ruleset active?")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivateRulesetResponse activateRulesetResponse = (ActivateRulesetResponse) o;
    return Objects.equals(this.client, activateRulesetResponse.client) &&
        Objects.equals(this.project, activateRulesetResponse.project) &&
        Objects.equals(this.ruleset, activateRulesetResponse.ruleset) &&
        Objects.equals(this.version, activateRulesetResponse.version) &&
        Objects.equals(this.active, activateRulesetResponse.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(client, project, ruleset, version, active);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivateRulesetResponse {\n");
    sb.append("    client: ").append(toIndentedString(client)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

