/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.models.RuleType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * UpdateRuleTypesRequest
 */
@JsonPropertyOrder({
  UpdateRuleTypesRequest.JSON_PROPERTY_MERGE,
  UpdateRuleTypesRequest.JSON_PROPERTY_TYPES
})

public class UpdateRuleTypesRequest {
  public static final String JSON_PROPERTY_MERGE = "merge";
  private Boolean merge = false;

  public static final String JSON_PROPERTY_TYPES = "types";
  private List<RuleType> types = null;


  public UpdateRuleTypesRequest merge(Boolean merge) {
    
    this.merge = merge;
    return this;
  }

   /**
   * Merge or replace types
   * @return merge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Merge or replace types")
  @JsonProperty(JSON_PROPERTY_MERGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMerge() {
    return merge;
  }


  public void setMerge(Boolean merge) {
    this.merge = merge;
  }


  public UpdateRuleTypesRequest types(List<RuleType> types) {
    
    this.types = types;
    return this;
  }

  public UpdateRuleTypesRequest addTypesItem(RuleType typesItem) {
    if (this.types == null) {
      this.types = new ArrayList<>();
    }
    this.types.add(typesItem);
    return this;
  }

   /**
   * Rule types
   * @return types
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule types")
  @JsonProperty(JSON_PROPERTY_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RuleType> getTypes() {
    return types;
  }


  public void setTypes(List<RuleType> types) {
    this.types = types;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateRuleTypesRequest updateRuleTypesRequest = (UpdateRuleTypesRequest) o;
    return Objects.equals(this.merge, updateRuleTypesRequest.merge) &&
        Objects.equals(this.types, updateRuleTypesRequest.types);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merge, types);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateRuleTypesRequest {\n");
    sb.append("    merge: ").append(toIndentedString(merge)).append("\n");
    sb.append("    types: ").append(toIndentedString(types)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

