/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.models.Assertion;
import io.logicdrop.openapi.models.DesignerOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * AnalyzeRequest
 */
@JsonPropertyOrder({
  AnalyzeRequest.JSON_PROPERTY_PROJECT,
  AnalyzeRequest.JSON_PROPERTY_RULESET,
  AnalyzeRequest.JSON_PROPERTY_VERSION,
  AnalyzeRequest.JSON_PROPERTY_PROPERTIES,
  AnalyzeRequest.JSON_PROPERTY_FILTER,
  AnalyzeRequest.JSON_PROPERTY_INPUTS,
  AnalyzeRequest.JSON_PROPERTY_OUTPUTS,
  AnalyzeRequest.JSON_PROPERTY_OPTIONS,
  AnalyzeRequest.JSON_PROPERTY_RULES,
  AnalyzeRequest.JSON_PROPERTY_ASSERTIONS
})

public class AnalyzeRequest {
  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private List<String> filter = null;

  public static final String JSON_PROPERTY_INPUTS = "inputs";
  private List<Map<String, Object>> inputs = null;

  public static final String JSON_PROPERTY_OUTPUTS = "outputs";
  private List<String> outputs = null;

  public static final String JSON_PROPERTY_OPTIONS = "options";
  private DesignerOptions options;

  public static final String JSON_PROPERTY_RULES = "rules";
  private List<String> rules = null;

  public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
  private List<Assertion> assertions = null;


  public AnalyzeRequest project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public AnalyzeRequest ruleset(String ruleset) {
    
    this.ruleset = ruleset;
    return this;
  }

   /**
   * Ruleset name
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset name")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }


  public void setRuleset(String ruleset) {
    this.ruleset = ruleset;
  }


  public AnalyzeRequest version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Ruleset version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public AnalyzeRequest properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public AnalyzeRequest putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * User properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User properties")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public AnalyzeRequest filter(List<String> filter) {
    
    this.filter = filter;
    return this;
  }

  public AnalyzeRequest addFilterItem(String filterItem) {
    if (this.filter == null) {
      this.filter = new ArrayList<>();
    }
    this.filter.add(filterItem);
    return this;
  }

   /**
   * Inputs filter
   * @return filter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Inputs filter")
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFilter() {
    return filter;
  }


  public void setFilter(List<String> filter) {
    this.filter = filter;
  }


  public AnalyzeRequest inputs(List<Map<String, Object>> inputs) {
    
    this.inputs = inputs;
    return this;
  }

  public AnalyzeRequest addInputsItem(Map<String, Object> inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

   /**
   * Inputs to process
   * @return inputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Inputs to process")
  @JsonProperty(JSON_PROPERTY_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Map<String, Object>> getInputs() {
    return inputs;
  }


  public void setInputs(List<Map<String, Object>> inputs) {
    this.inputs = inputs;
  }


  public AnalyzeRequest outputs(List<String> outputs) {
    
    this.outputs = outputs;
    return this;
  }

  public AnalyzeRequest addOutputsItem(String outputsItem) {
    if (this.outputs == null) {
      this.outputs = new ArrayList<>();
    }
    this.outputs.add(outputsItem);
    return this;
  }

   /**
   * Outputs to return (by name)
   * @return outputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Outputs to return (by name)")
  @JsonProperty(JSON_PROPERTY_OUTPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getOutputs() {
    return outputs;
  }


  public void setOutputs(List<String> outputs) {
    this.outputs = outputs;
  }


  public AnalyzeRequest options(DesignerOptions options) {
    
    this.options = options;
    return this;
  }

   /**
   * Get options
   * @return options
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DesignerOptions getOptions() {
    return options;
  }


  public void setOptions(DesignerOptions options) {
    this.options = options;
  }


  public AnalyzeRequest rules(List<String> rules) {
    
    this.rules = rules;
    return this;
  }

  public AnalyzeRequest addRulesItem(String rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<>();
    }
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * Rule ID(s) to execute
   * @return rules
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule ID(s) to execute")
  @JsonProperty(JSON_PROPERTY_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRules() {
    return rules;
  }


  public void setRules(List<String> rules) {
    this.rules = rules;
  }


  public AnalyzeRequest assertions(List<Assertion> assertions) {
    
    this.assertions = assertions;
    return this;
  }

  public AnalyzeRequest addAssertionsItem(Assertion assertionsItem) {
    if (this.assertions == null) {
      this.assertions = new ArrayList<>();
    }
    this.assertions.add(assertionsItem);
    return this;
  }

   /**
   * Assertions to apply
   * @return assertions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Assertions to apply")
  @JsonProperty(JSON_PROPERTY_ASSERTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Assertion> getAssertions() {
    return assertions;
  }


  public void setAssertions(List<Assertion> assertions) {
    this.assertions = assertions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalyzeRequest analyzeRequest = (AnalyzeRequest) o;
    return Objects.equals(this.project, analyzeRequest.project) &&
        Objects.equals(this.ruleset, analyzeRequest.ruleset) &&
        Objects.equals(this.version, analyzeRequest.version) &&
        Objects.equals(this.properties, analyzeRequest.properties) &&
        Objects.equals(this.filter, analyzeRequest.filter) &&
        Objects.equals(this.inputs, analyzeRequest.inputs) &&
        Objects.equals(this.outputs, analyzeRequest.outputs) &&
        Objects.equals(this.options, analyzeRequest.options) &&
        Objects.equals(this.rules, analyzeRequest.rules) &&
        Objects.equals(this.assertions, analyzeRequest.assertions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(project, ruleset, version, properties, filter, inputs, outputs, options, rules, assertions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnalyzeRequest {\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    outputs: ").append(toIndentedString(outputs)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    assertions: ").append(toIndentedString(assertions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

