package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import java.io.File;
import io.logicdrop.openapi.models.GenerateTemplateRequest;
import io.logicdrop.openapi.models.InlineResponse200;
import io.logicdrop.openapi.models.Template;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateTemplateResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class TemplateServicesApi {
  private ApiClient apiClient;

  public TemplateServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TemplateServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Delete template
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteTemplate(String client, String project, String artifact, String v) throws ApiException {
    return deleteTemplateWithHttpInfo(client, project, artifact, v).getData();
  }

  /**
   * Delete template
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteTemplateWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteTemplate");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteTemplate");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.deleteTemplate", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete templates
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove templates by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteTemplates(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    return deleteTemplatesWithHttpInfo(client, project, deleteArtifactRequest).getData();
  }

  /**
   * Delete templates
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove templates by criteria (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteTemplatesWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    Object localVarPostBody = deleteArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteTemplates");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteTemplates");
    }
    
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.deleteTemplates", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Generate template
   * Generate template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param generateTemplateRequest  (optional)
   * @return InlineResponse200
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The generated content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public InlineResponse200 generateTemplate(String client, String project, String artifact, String v, GenerateTemplateRequest generateTemplateRequest) throws ApiException {
    return generateTemplateWithHttpInfo(client, project, artifact, v, generateTemplateRequest).getData();
  }

  /**
   * Generate template
   * Generate template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param generateTemplateRequest  (optional)
   * @return ApiResponse&lt;InlineResponse200&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The generated content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<InlineResponse200> generateTemplateWithHttpInfo(String client, String project, String artifact, String v, GenerateTemplateRequest generateTemplateRequest) throws ApiException {
    Object localVarPostBody = generateTemplateRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling generateTemplate");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling generateTemplate");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling generateTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}/generate"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "*/*"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>() {};
    return apiClient.invokeAPI("TemplateServicesApi.generateTemplate", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get template
   * Get an template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return Template
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved template </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Template getTemplate(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    return getTemplateWithHttpInfo(client, project, artifact, v, view).getData();
  }

  /**
   * Get template
   * Get an template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;Template&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved template </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Template> getTemplateWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getTemplate");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getTemplate");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Template> localVarReturnType = new GenericType<Template>() {};
    return apiClient.invokeAPI("TemplateServicesApi.getTemplate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get content
   * Get template content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @return String
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public String getTemplateContent(String client, String project, String artifact, String v) throws ApiException {
    return getTemplateContentWithHttpInfo(client, project, artifact, v).getData();
  }

  /**
   * Get content
   * Get template content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<String> getTemplateContentWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getTemplateContent");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getTemplateContent");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getTemplateContent");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "text/plain"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<String> localVarReturnType = new GenericType<String>() {};
    return apiClient.invokeAPI("TemplateServicesApi.getTemplateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List templates
   * Get templates using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return List&lt;Template&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved templates </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Template> listTemplates(String client, String project, List<String> view) throws ApiException {
    return listTemplatesWithHttpInfo(client, project, view).getData();
  }

  /**
   * List templates
   * Get templates using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;List&lt;Template&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved templates </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Template>> listTemplatesWithHttpInfo(String client, String project, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listTemplates");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Template>> localVarReturnType = new GenericType<List<Template>>() {};
    return apiClient.invokeAPI("TemplateServicesApi.listTemplates", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Save template
   * Saves or creates a template (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param template Template to persist (required)
   * @return Template
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved template </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Template saveTemplate(String client, String project, Template template) throws ApiException {
    return saveTemplateWithHttpInfo(client, project, template).getData();
  }

  /**
   * Save template
   * Saves or creates a template (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param template Template to persist (required)
   * @return ApiResponse&lt;Template&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved template </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Template> saveTemplateWithHttpInfo(String client, String project, Template template) throws ApiException {
    Object localVarPostBody = template;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling saveTemplate");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling saveTemplate");
    }
    
    // verify the required parameter 'template' is set
    if (template == null) {
      throw new ApiException(400, "Missing the required parameter 'template' when calling saveTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Template> localVarReturnType = new GenericType<Template>() {};
    return apiClient.invokeAPI("TemplateServicesApi.saveTemplate", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update template
   * Updates one template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Templates to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateTemplate(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateTemplateWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update template
   * Updates one template
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Templates to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateTemplateWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplate");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplate");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.updateTemplate", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update content using file
   * Update the template with using a file
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param file File (optional)
   * @return UpdateTemplateResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded custom files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UpdateTemplateResponse updateTemplateContentFile(String client, String project, String artifact, String v, File file) throws ApiException {
    return updateTemplateContentFileWithHttpInfo(client, project, artifact, v, file).getData();
  }

  /**
   * Update content using file
   * Update the template with using a file
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param file File (optional)
   * @return ApiResponse&lt;UpdateTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded custom files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UpdateTemplateResponse> updateTemplateContentFileWithHttpInfo(String client, String project, String artifact, String v, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplateContentFile");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplateContentFile");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateTemplateContentFile");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UpdateTemplateResponse> localVarReturnType = new GenericType<UpdateTemplateResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.updateTemplateContentFile", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update content using string
   * Update the template using a string
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param body  (optional)
   * @return UpdateTemplateResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The update results </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UpdateTemplateResponse updateTemplateContentText(String client, String project, String artifact, String v, String body) throws ApiException {
    return updateTemplateContentTextWithHttpInfo(client, project, artifact, v, body).getData();
  }

  /**
   * Update content using string
   * Update the template using a string
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Template name (required)
   * @param v Template version (optional)
   * @param body  (optional)
   * @return ApiResponse&lt;UpdateTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The update results </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UpdateTemplateResponse> updateTemplateContentTextWithHttpInfo(String client, String project, String artifact, String v, String body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplateContentText");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplateContentText");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateTemplateContentText");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "text/plain"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UpdateTemplateResponse> localVarReturnType = new GenericType<UpdateTemplateResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.updateTemplateContentText", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update templates
   * Updates multiple templates
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Templates to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateTemplates(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateTemplatesWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update templates
   * Updates multiple templates
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Templates to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateTemplatesWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplates");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplates");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("TemplateServicesApi.updateTemplates", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
