package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.SubscriberDetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SubscriptionServicesApi {
  private ApiClient apiClient;

  public SubscriptionServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SubscriptionServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Create subscription
   * Create a client subscription
   * @param client Client name (required)
   * @param subscriberDetails Create subscription request (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void createSubscription(String client, SubscriberDetails subscriberDetails) throws ApiException {
    createSubscriptionWithHttpInfo(client, subscriberDetails);
  }

  /**
   * Create subscription
   * Create a client subscription
   * @param client Client name (required)
   * @param subscriberDetails Create subscription request (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> createSubscriptionWithHttpInfo(String client, SubscriberDetails subscriberDetails) throws ApiException {
    Object localVarPostBody = subscriberDetails;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling createSubscription");
    }
    
    // verify the required parameter 'subscriberDetails' is set
    if (subscriberDetails == null) {
      throw new ApiException(400, "Missing the required parameter 'subscriberDetails' when calling createSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscription/{client}/create"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("SubscriptionServicesApi.createSubscription", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Get subscription
   * Get client subscription
   * @param client Client name (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void getSubscription(String client) throws ApiException {
    getSubscriptionWithHttpInfo(client);
  }

  /**
   * Get subscription
   * Get client subscription
   * @param client Client name (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> getSubscriptionWithHttpInfo(String client) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscription/{client}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("SubscriptionServicesApi.getSubscription", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Update subscription
   * Update a client subscription
   * @param client Client name (required)
   * @param subscriberDetails Update subscription request (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void updateSubscription(String client, SubscriberDetails subscriberDetails) throws ApiException {
    updateSubscriptionWithHttpInfo(client, subscriberDetails);
  }

  /**
   * Update subscription
   * Update a client subscription
   * @param client Client name (required)
   * @param subscriberDetails Update subscription request (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> updateSubscriptionWithHttpInfo(String client, SubscriberDetails subscriberDetails) throws ApiException {
    Object localVarPostBody = subscriberDetails;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateSubscription");
    }
    
    // verify the required parameter 'subscriberDetails' is set
    if (subscriberDetails == null) {
      throw new ApiException(400, "Missing the required parameter 'subscriberDetails' when calling updateSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscription/{client}/update"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("SubscriptionServicesApi.updateSubscription", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Change payment method
   * Change subscription payment method
   * @param client Client name (required)
   * @param subscriberDetails Change payment method request (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void updateSubscriptionPayment(String client, SubscriberDetails subscriberDetails) throws ApiException {
    updateSubscriptionPaymentWithHttpInfo(client, subscriberDetails);
  }

  /**
   * Change payment method
   * Change subscription payment method
   * @param client Client name (required)
   * @param subscriberDetails Change payment method request (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> No records match </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> updateSubscriptionPaymentWithHttpInfo(String client, SubscriberDetails subscriberDetails) throws ApiException {
    Object localVarPostBody = subscriberDetails;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateSubscriptionPayment");
    }
    
    // verify the required parameter 'subscriberDetails' is set
    if (subscriberDetails == null) {
      throw new ApiException(400, "Missing the required parameter 'subscriberDetails' when calling updateSubscriptionPayment");
    }
    
    // create path and map variables
    String localVarPath = "/subscription/{client}/pay"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("SubscriptionServicesApi.updateSubscriptionPayment", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
}
