package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.Schema;
import io.logicdrop.openapi.models.UpdateArtifactRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SchemaServicesApi {
  private ApiClient apiClient;

  public SchemaServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SchemaServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Delete schema
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Schema name (required)
   * @param v Schema version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteSchema(String client, String project, String artifact, String v) throws ApiException {
    return deleteSchemaWithHttpInfo(client, project, artifact, v).getData();
  }

  /**
   * Delete schema
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Schema name (required)
   * @param v Schema version (optional)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteSchemaWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteSchema");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteSchema");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteSchema");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("SchemaServicesApi.deleteSchema", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete schemas
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove schemas by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteSchemas(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    return deleteSchemasWithHttpInfo(client, project, deleteArtifactRequest).getData();
  }

  /**
   * Delete schemas
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove schemas by criteria (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteSchemasWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    Object localVarPostBody = deleteArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteSchemas");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteSchemas");
    }
    
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteSchemas");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("SchemaServicesApi.deleteSchemas", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get schema
   * Get an schema
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Schema name (required)
   * @param v Schema version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return Schema
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved schemas </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Schema getSchema(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    return getSchemaWithHttpInfo(client, project, artifact, v, view).getData();
  }

  /**
   * Get schema
   * Get an schema
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Schema name (required)
   * @param v Schema version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;Schema&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved schemas </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Schema> getSchemaWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getSchema");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getSchema");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getSchema");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Schema> localVarReturnType = new GenericType<Schema>() {};
    return apiClient.invokeAPI("SchemaServicesApi.getSchema", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List schemas
   * Get schemas using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Comma separated fields to include (optional)
   * @return List&lt;Schema&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved schemas </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Schema> listSchemas(String client, String project, String view) throws ApiException {
    return listSchemasWithHttpInfo(client, project, view).getData();
  }

  /**
   * List schemas
   * Get schemas using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Comma separated fields to include (optional)
   * @return ApiResponse&lt;List&lt;Schema&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved schemas </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Schema>> listSchemasWithHttpInfo(String client, String project, String view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listSchemas");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listSchemas");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Schema>> localVarReturnType = new GenericType<List<Schema>>() {};
    return apiClient.invokeAPI("SchemaServicesApi.listSchemas", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Save schema
   * Saves or creates a schema (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param schema Schema to persist (required)
   * @return Schema
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved schema </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Schema saveSchema(String client, String project, Schema schema) throws ApiException {
    return saveSchemaWithHttpInfo(client, project, schema).getData();
  }

  /**
   * Save schema
   * Saves or creates a schema (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param schema Schema to persist (required)
   * @return ApiResponse&lt;Schema&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved schema </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Schema> saveSchemaWithHttpInfo(String client, String project, Schema schema) throws ApiException {
    Object localVarPostBody = schema;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling saveSchema");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling saveSchema");
    }
    
    // verify the required parameter 'schema' is set
    if (schema == null) {
      throw new ApiException(400, "Missing the required parameter 'schema' when calling saveSchema");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Schema> localVarReturnType = new GenericType<Schema>() {};
    return apiClient.invokeAPI("SchemaServicesApi.saveSchema", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update schema
   * Updates one schema
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Schemas to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateSchema(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateSchemaWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update schema
   * Updates one schema
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Schemas to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateSchemaWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateSchema");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateSchema");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateSchema");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("SchemaServicesApi.updateSchema", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update schemas
   * Updates multiple schemas
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Schemas to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateSchemas(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateSchemasWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update schemas
   * Updates multiple schemas
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Schemas to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateSchemasWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateSchemas");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateSchemas");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateSchemas");
    }
    
    // create path and map variables
    String localVarPath = "/schemas/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("SchemaServicesApi.updateSchemas", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
