package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.PipelineMessage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class PipelineServicesApi {
  private ApiClient apiClient;

  public PipelineServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public PipelineServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Execute pipeline
   * Executes a pipeline
   * @param client Client name (required)
   * @param route Route (required)
   * @param pipelineMessage Pipeline request (required)
   * @return PipelineMessage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Pipeline response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public PipelineMessage executePipeline(String client, String route, PipelineMessage pipelineMessage) throws ApiException {
    return executePipelineWithHttpInfo(client, route, pipelineMessage).getData();
  }

  /**
   * Execute pipeline
   * Executes a pipeline
   * @param client Client name (required)
   * @param route Route (required)
   * @param pipelineMessage Pipeline request (required)
   * @return ApiResponse&lt;PipelineMessage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Pipeline response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<PipelineMessage> executePipelineWithHttpInfo(String client, String route, PipelineMessage pipelineMessage) throws ApiException {
    Object localVarPostBody = pipelineMessage;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling executePipeline");
    }
    
    // verify the required parameter 'route' is set
    if (route == null) {
      throw new ApiException(400, "Missing the required parameter 'route' when calling executePipeline");
    }
    
    // verify the required parameter 'pipelineMessage' is set
    if (pipelineMessage == null) {
      throw new ApiException(400, "Missing the required parameter 'pipelineMessage' when calling executePipeline");
    }
    
    // create path and map variables
    String localVarPath = "/pipeline/{client}/{route}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "route" + "\\}", apiClient.escapeString(route.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "*/*"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<PipelineMessage> localVarReturnType = new GenericType<PipelineMessage>() {};
    return apiClient.invokeAPI("PipelineServicesApi.executePipeline", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Execute pipeline route
   * Executes a pipeline route
   * @param client Client name (required)
   * @param route Route (required)
   * @param pipelineMessage Pipeline request (required)
   * @return PipelineMessage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Pipeline response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public PipelineMessage executePipelineRoute(String client, String route, PipelineMessage pipelineMessage) throws ApiException {
    return executePipelineRouteWithHttpInfo(client, route, pipelineMessage).getData();
  }

  /**
   * Execute pipeline route
   * Executes a pipeline route
   * @param client Client name (required)
   * @param route Route (required)
   * @param pipelineMessage Pipeline request (required)
   * @return ApiResponse&lt;PipelineMessage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Pipeline response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<PipelineMessage> executePipelineRouteWithHttpInfo(String client, String route, PipelineMessage pipelineMessage) throws ApiException {
    Object localVarPostBody = pipelineMessage;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling executePipelineRoute");
    }
    
    // verify the required parameter 'route' is set
    if (route == null) {
      throw new ApiException(400, "Missing the required parameter 'route' when calling executePipelineRoute");
    }
    
    // verify the required parameter 'pipelineMessage' is set
    if (pipelineMessage == null) {
      throw new ApiException(400, "Missing the required parameter 'pipelineMessage' when calling executePipelineRoute");
    }
    
    // create path and map variables
    String localVarPath = "/pipeline/{client}/execute"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "route" + "\\}", apiClient.escapeString(route.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "*/*"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<PipelineMessage> localVarReturnType = new GenericType<PipelineMessage>() {};
    return apiClient.invokeAPI("PipelineServicesApi.executePipelineRoute", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
