package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.Bundle;
import java.io.File;
import io.logicdrop.openapi.models.ScaffoldRequest;
import io.logicdrop.openapi.models.ScaffoldResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class PackageServicesApi {
  private ApiClient apiClient;

  public PackageServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public PackageServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Delete package
   * Delete package
   * @param client Client name (required)
   * @param _package Package name (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deletePackage(String client, String _package) throws ApiException {
    return deletePackageWithHttpInfo(client, _package).getData();
  }

  /**
   * Delete package
   * Delete package
   * @param client Client name (required)
   * @param _package Package name (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deletePackageWithHttpInfo(String client, String _package) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deletePackage");
    }
    
    // verify the required parameter '_package' is set
    if (_package == null) {
      throw new ApiException(400, "Missing the required parameter '_package' when calling deletePackage");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}/{package}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "package" + "\\}", apiClient.escapeString(_package.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("PackageServicesApi.deletePackage", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get package
   * Get package
   * @param client Client name (required)
   * @param _package Package name (required)
   * @return Bundle
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The package </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Bundle getPackage(String client, String _package) throws ApiException {
    return getPackageWithHttpInfo(client, _package).getData();
  }

  /**
   * Get package
   * Get package
   * @param client Client name (required)
   * @param _package Package name (required)
   * @return ApiResponse&lt;Bundle&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The package </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Bundle> getPackageWithHttpInfo(String client, String _package) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getPackage");
    }
    
    // verify the required parameter '_package' is set
    if (_package == null) {
      throw new ApiException(400, "Missing the required parameter '_package' when calling getPackage");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}/{package}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "package" + "\\}", apiClient.escapeString(_package.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Bundle> localVarReturnType = new GenericType<Bundle>() {};
    return apiClient.invokeAPI("PackageServicesApi.getPackage", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List packages
   * Get packages
   * @param client Client name (required)
   * @return List&lt;Bundle&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved packages </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Bundle> listPackages(String client) throws ApiException {
    return listPackagesWithHttpInfo(client).getData();
  }

  /**
   * List packages
   * Get packages
   * @param client Client name (required)
   * @return ApiResponse&lt;List&lt;Bundle&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved packages </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Bundle>> listPackagesWithHttpInfo(String client) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listPackages");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Bundle>> localVarReturnType = new GenericType<List<Bundle>>() {};
    return apiClient.invokeAPI("PackageServicesApi.listPackages", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Scaffold project
   * Scaffold project
   * @param client Client name (required)
   * @param scaffoldRequest Scaffold request (required)
   * @return ScaffoldResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Scaffold response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ScaffoldResponse scaffoldProject(String client, ScaffoldRequest scaffoldRequest) throws ApiException {
    return scaffoldProjectWithHttpInfo(client, scaffoldRequest).getData();
  }

  /**
   * Scaffold project
   * Scaffold project
   * @param client Client name (required)
   * @param scaffoldRequest Scaffold request (required)
   * @return ApiResponse&lt;ScaffoldResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Scaffold response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ScaffoldResponse> scaffoldProjectWithHttpInfo(String client, ScaffoldRequest scaffoldRequest) throws ApiException {
    Object localVarPostBody = scaffoldRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling scaffoldProject");
    }
    
    // verify the required parameter 'scaffoldRequest' is set
    if (scaffoldRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'scaffoldRequest' when calling scaffoldProject");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}/scaffold"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ScaffoldResponse> localVarReturnType = new GenericType<ScaffoldResponse>() {};
    return apiClient.invokeAPI("PackageServicesApi.scaffoldProject", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Upload packages
   * Upload packages(s)
   * @param client Client name (required)
   * @param file File (optional)
   * @return List&lt;Bundle&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Bundle> uploadPackage(String client, File file) throws ApiException {
    return uploadPackageWithHttpInfo(client, file).getData();
  }

  /**
   * Upload packages
   * Upload packages(s)
   * @param client Client name (required)
   * @param file File (optional)
   * @return ApiResponse&lt;List&lt;Bundle&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Bundle>> uploadPackageWithHttpInfo(String client, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling uploadPackage");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Bundle>> localVarReturnType = new GenericType<List<Bundle>>() {};
    return apiClient.invokeAPI("PackageServicesApi.uploadPackage", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Upload scaffold
   * Upload a scaffold project
   * @param client Client name (required)
   * @param file File (optional)
   * @return ScaffoldResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Scaffold response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ScaffoldResponse uploadScaffold(String client, File file) throws ApiException {
    return uploadScaffoldWithHttpInfo(client, file).getData();
  }

  /**
   * Upload scaffold
   * Upload a scaffold project
   * @param client Client name (required)
   * @param file File (optional)
   * @return ApiResponse&lt;ScaffoldResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Scaffold response </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ScaffoldResponse> uploadScaffoldWithHttpInfo(String client, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling uploadScaffold");
    }
    
    // create path and map variables
    String localVarPath = "/packages/{client}/scaffold/upload"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ScaffoldResponse> localVarReturnType = new GenericType<ScaffoldResponse>() {};
    return apiClient.invokeAPI("PackageServicesApi.uploadScaffold", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
