package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.models.Archive;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.Dataset;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.ExternalSource;
import java.io.File;
import io.logicdrop.openapi.models.SaveContentRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateDataRequest;
import io.logicdrop.openapi.models.UploadResponse;
import io.logicdrop.openapi.models.UserData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class DataServicesApi {
  private ApiClient apiClient;

  public DataServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DataServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Archive dataset
   * Archive a dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @return Archive
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archived record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Archive archiveDataset(String client, String project, String artifact, String v) throws ApiException {
    return archiveDatasetWithHttpInfo(client, project, artifact, v).getData();
  }

  /**
   * Archive dataset
   * Archive a dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;Archive&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archived record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Archive> archiveDatasetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling archiveDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling archiveDataset");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling archiveDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/archives"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Archive> localVarReturnType = new GenericType<Archive>() {};
    return apiClient.invokeAPI("DataServicesApi.archiveDataset", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Archive record
   * Archive a record
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @return Archive
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archived record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Archive archiveRecord(String client, String project, String artifact, String id, String v) throws ApiException {
    return archiveRecordWithHttpInfo(client, project, artifact, id, v).getData();
  }

  /**
   * Archive record
   * Archive a record
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;Archive&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archived record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Archive> archiveRecordWithHttpInfo(String client, String project, String artifact, String id, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling archiveRecord");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling archiveRecord");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling archiveRecord");
    }
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling archiveRecord");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}/archives"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Archive> localVarReturnType = new GenericType<Archive>() {};
    return apiClient.invokeAPI("DataServicesApi.archiveRecord", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete dataset
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteDataset(String client, String project, String artifact, String v) throws ApiException {
    return deleteDatasetWithHttpInfo(client, project, artifact, v).getData();
  }

  /**
   * Delete dataset
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteDatasetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteDataset");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.deleteDataset", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete datasets
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove datasets by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse deleteDatasets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    return deleteDatasetsWithHttpInfo(client, project, deleteArtifactRequest).getData();
  }

  /**
   * Delete datasets
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove datasets by criteria (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> deleteDatasetsWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    Object localVarPostBody = deleteArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteDatasets");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteDatasets");
    }
    
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteDatasets");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.deleteDatasets", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete record
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @return DataResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public DataResponse deleteRecord(String client, String project, String artifact, String id, String v) throws ApiException {
    return deleteRecordWithHttpInfo(client, project, artifact, id, v).getData();
  }

  /**
   * Delete record
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;DataResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<DataResponse> deleteRecordWithHttpInfo(String client, String project, String artifact, String id, String v) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRecord");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRecord");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRecord");
    }
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteRecord");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.deleteRecord", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete records
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param deleteDataRequest Remove records by criteria (required)
   * @param v Dataset version (optional)
   * @return DataResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public DataResponse deleteRecords(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
    return deleteRecordsWithHttpInfo(client, project, artifact, deleteDataRequest, v).getData();
  }

  /**
   * Delete records
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param deleteDataRequest Remove records by criteria (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;DataResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<DataResponse> deleteRecordsWithHttpInfo(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
    Object localVarPostBody = deleteDataRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRecords");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRecords");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRecords");
    }
    
    // verify the required parameter 'deleteDataRequest' is set
    if (deleteDataRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'deleteDataRequest' when calling deleteRecords");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.deleteRecords", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get dataset
   * Get a dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return Dataset
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved dataset </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Dataset getDataset(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    return getDatasetWithHttpInfo(client, project, artifact, v, view).getData();
  }

  /**
   * Get dataset
   * Get a dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;Dataset&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved dataset </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Dataset> getDatasetWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getDataset");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Dataset> localVarReturnType = new GenericType<Dataset>() {};
    return apiClient.invokeAPI("DataServicesApi.getDataset", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get content
   * Get dataset content using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Object getDatasetContent(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    return getDatasetContentWithHttpInfo(client, project, artifact, v, view).getData();
  }

  /**
   * Get content
   * Get dataset content using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved content </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Object> getDatasetContentWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getDatasetContent");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getDatasetContent");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getDatasetContent");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI("DataServicesApi.getDatasetContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get record
   * Get a record
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData getRecord(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
    return getRecordWithHttpInfo(client, project, artifact, id, v, view).getData();
  }

  /**
   * Get record
   * Get a record
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> getRecordWithHttpInfo(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getRecord");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling getRecord");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRecord");
    }
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getRecord");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI("DataServicesApi.getRecord", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List dataset archives
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @return List&lt;Archive&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archives </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Archive> listDatasetArchives(String client, String project, String artifact) throws ApiException {
    return listDatasetArchivesWithHttpInfo(client, project, artifact).getData();
  }

  /**
   * List dataset archives
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @return ApiResponse&lt;List&lt;Archive&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archives </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Archive>> listDatasetArchivesWithHttpInfo(String client, String project, String artifact) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listDatasetArchives");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listDatasetArchives");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling listDatasetArchives");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/archives"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Archive>> localVarReturnType = new GenericType<List<Archive>>() {};
    return apiClient.invokeAPI("DataServicesApi.listDatasetArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List datasets
   * Get datasets using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return List&lt;Dataset&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved datasets </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Dataset> listDatasets(String client, String project, List<String> view) throws ApiException {
    return listDatasetsWithHttpInfo(client, project, view).getData();
  }

  /**
   * List datasets
   * Get datasets using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;List&lt;Dataset&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved datasets </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Dataset>> listDatasetsWithHttpInfo(String client, String project, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listDatasets");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listDatasets");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Dataset>> localVarReturnType = new GenericType<List<Dataset>>() {};
    return apiClient.invokeAPI("DataServicesApi.listDatasets", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List record archives
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @return List&lt;Archive&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archives </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<Archive> listRecordArchives(String client, String project, String artifact, String id) throws ApiException {
    return listRecordArchivesWithHttpInfo(client, project, artifact, id).getData();
  }

  /**
   * List record archives
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param id Record Id (required)
   * @return ApiResponse&lt;List&lt;Archive&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Archives </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<Archive>> listRecordArchivesWithHttpInfo(String client, String project, String artifact, String id) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listRecordArchives");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listRecordArchives");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecordArchives");
    }
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling listRecordArchives");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}/archives"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<Archive>> localVarReturnType = new GenericType<List<Archive>>() {};
    return apiClient.invokeAPI("DataServicesApi.listRecordArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List records
   * Get records using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param criteria SQL-like query (optional)
   * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
   * @param value Value to find in any fields (requires fields) (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
   * @param order Fields to order by (field:asc|desc) (optional, default to new ArrayList&lt;&gt;())
   * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
   * @param ignoreCase Ignore case (optional, default to false)
   * @param limit Limit result size (optional, default to 0)
   * @return List&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved records </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<UserData> listRecords(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws ApiException {
    return listRecordsWithHttpInfo(client, project, artifact, v, criteria, fields, value, view, filter, order, tags, ignoreCase, limit).getData();
  }

  /**
   * List records
   * Get records using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param v Dataset version (optional)
   * @param criteria SQL-like query (optional)
   * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
   * @param value Value to find in any fields (requires fields) (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
   * @param order Fields to order by (field:asc|desc) (optional, default to new ArrayList&lt;&gt;())
   * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
   * @param ignoreCase Ignore case (optional, default to false)
   * @param limit Limit result size (optional, default to 0)
   * @return ApiResponse&lt;List&lt;UserData&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved records </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<UserData>> listRecordsWithHttpInfo(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listRecords");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listRecords");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecords");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "criteria", criteria));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "fields", fields));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "value", value));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "filter", filter));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "order", order));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "tags", tags));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ignoreCase", ignoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<UserData>> localVarReturnType = new GenericType<List<UserData>>() {};
    return apiClient.invokeAPI("DataServicesApi.listRecords", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List records by key
   * Get records using a single key/value
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param key Field name (required)
   * @param value Field value (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return List&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved record(s) </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<UserData> listRecordsBy(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
    return listRecordsByWithHttpInfo(client, project, artifact, key, value, v, view).getData();
  }

  /**
   * List records by key
   * Get records using a single key/value
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param key Field name (required)
   * @param value Field value (required)
   * @param v Dataset version (optional)
   * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
   * @return ApiResponse&lt;List&lt;UserData&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved record(s) </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<UserData>> listRecordsByWithHttpInfo(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listRecordsBy");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling listRecordsBy");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecordsBy");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling listRecordsBy");
    }
    
    // verify the required parameter 'value' is set
    if (value == null) {
      throw new ApiException(400, "Missing the required parameter 'value' when calling listRecordsBy");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows/by/{key}/{value}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "value" + "\\}", apiClient.escapeString(value.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "view", view));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<UserData>> localVarReturnType = new GenericType<List<UserData>>() {};
    return apiClient.invokeAPI("DataServicesApi.listRecordsBy", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List external sources
   * Get available external sources or check if a source exists
   * @param client Client name (required)
   * @param check Check if source name exists? (optional)
   * @return List&lt;ExternalSource&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved external sources </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<ExternalSource> listSources(String client, String check) throws ApiException {
    return listSourcesWithHttpInfo(client, check).getData();
  }

  /**
   * List external sources
   * Get available external sources or check if a source exists
   * @param client Client name (required)
   * @param check Check if source name exists? (optional)
   * @return ApiResponse&lt;List&lt;ExternalSource&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved external sources </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<ExternalSource>> listSourcesWithHttpInfo(String client, String check) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listSources");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/sources"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "check", check));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<ExternalSource>> localVarReturnType = new GenericType<List<ExternalSource>>() {};
    return apiClient.invokeAPI("DataServicesApi.listSources", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Save dataset
   * Saves or creates an dataset (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param dataset Dataset to persist (required)
   * @return Dataset
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved dataset </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Dataset saveDataset(String client, String project, Dataset dataset) throws ApiException {
    return saveDatasetWithHttpInfo(client, project, dataset).getData();
  }

  /**
   * Save dataset
   * Saves or creates an dataset (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param dataset Dataset to persist (required)
   * @return ApiResponse&lt;Dataset&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved dataset </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Dataset> saveDatasetWithHttpInfo(String client, String project, Dataset dataset) throws ApiException {
    Object localVarPostBody = dataset;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling saveDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling saveDataset");
    }
    
    // verify the required parameter 'dataset' is set
    if (dataset == null) {
      throw new ApiException(400, "Missing the required parameter 'dataset' when calling saveDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Dataset> localVarReturnType = new GenericType<Dataset>() {};
    return apiClient.invokeAPI("DataServicesApi.saveDataset", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Save content
   * Save dataset content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param saveContentRequest Content to persist (required)
   * @param v Dataset version (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Object saveDatasetContent(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws ApiException {
    return saveDatasetContentWithHttpInfo(client, project, artifact, saveContentRequest, v).getData();
  }

  /**
   * Save content
   * Save dataset content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param saveContentRequest Content to persist (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Object> saveDatasetContentWithHttpInfo(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws ApiException {
    Object localVarPostBody = saveContentRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling saveDatasetContent");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling saveDatasetContent");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveDatasetContent");
    }
    
    // verify the required parameter 'saveContentRequest' is set
    if (saveContentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'saveContentRequest' when calling saveDatasetContent");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI("DataServicesApi.saveDatasetContent", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Save record
   * Saves or create a record (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param requestBody Record to persist (required)
   * @param v Dataset version (optional)
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData saveRecord(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws ApiException {
    return saveRecordWithHttpInfo(client, project, artifact, requestBody, v).getData();
  }

  /**
   * Save record
   * Saves or create a record (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param requestBody Record to persist (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The saved record </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> saveRecordWithHttpInfo(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws ApiException {
    Object localVarPostBody = requestBody;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling saveRecord");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling saveRecord");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveRecord");
    }
    
    // verify the required parameter 'requestBody' is set
    if (requestBody == null) {
      throw new ApiException(400, "Missing the required parameter 'requestBody' when calling saveRecord");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI("DataServicesApi.saveRecord", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update dataset
   * Updates one dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Dataset to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateDataset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateDatasetWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update dataset
   * Updates one dataset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Dataset to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateDatasetWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateDataset");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.updateDataset", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update content
   * Update dataset content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param updateDataRequest Records to transform (required)
   * @param v Dataset version (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Object updateDatasetContent(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    return updateDatasetContentWithHttpInfo(client, project, artifact, updateDataRequest, v).getData();
  }

  /**
   * Update content
   * Update dataset content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param updateDataRequest Records to transform (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Object> updateDatasetContentWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    Object localVarPostBody = updateDataRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasetContent");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasetContent");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateDatasetContent");
    }
    
    // verify the required parameter 'updateDataRequest' is set
    if (updateDataRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContent");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/content"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI("DataServicesApi.updateDatasetContent", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update content item
   * Update dataset content item
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param index Index or property to save at (required)
   * @param updateDataRequest Content to persist at key (required)
   * @param v Dataset version (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public Object updateDatasetContentAt(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    return updateDatasetContentAtWithHttpInfo(client, project, artifact, index, updateDataRequest, v).getData();
  }

  /**
   * Update content item
   * Update dataset content item
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param index Index or property to save at (required)
   * @param updateDataRequest Content to persist at key (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Object> updateDatasetContentAtWithHttpInfo(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    Object localVarPostBody = updateDataRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasetContentAt");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasetContentAt");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateDatasetContentAt");
    }
    
    // verify the required parameter 'index' is set
    if (index == null) {
      throw new ApiException(400, "Missing the required parameter 'index' when calling updateDatasetContentAt");
    }
    
    // verify the required parameter 'updateDataRequest' is set
    if (updateDataRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContentAt");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/content/{index}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()))
      .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI("DataServicesApi.updateDatasetContentAt", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update datasets
   * Updates multiple datasets
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Datasets to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ArtifactResponse updateDatasets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    return updateDatasetsWithHttpInfo(client, project, updateArtifactRequest).getData();
  }

  /**
   * Update datasets
   * Updates multiple datasets
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Datasets to update (required)
   * @return ApiResponse&lt;ArtifactResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ArtifactResponse> updateDatasetsWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    Object localVarPostBody = updateArtifactRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasets");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasets");
    }
    
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateDatasets");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.updateDatasets", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Update records
   * Updates existing records (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param updateDataRequest Records to update (required)
   * @param v Dataset version (optional)
   * @return DataResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public DataResponse updateRecords(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    return updateRecordsWithHttpInfo(client, project, artifact, updateDataRequest, v).getData();
  }

  /**
   * Update records
   * Updates existing records (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param updateDataRequest Records to update (required)
   * @param v Dataset version (optional)
   * @return ApiResponse&lt;DataResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Results of the operation </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<DataResponse> updateRecordsWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
    Object localVarPostBody = updateDataRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling updateRecords");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling updateRecords");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRecords");
    }
    
    // verify the required parameter 'updateDataRequest' is set
    if (updateDataRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateRecords");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/rows"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.updateRecords", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Import datasets
   * Import datasets
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param identity Unique row identifier (key) (required)
   * @param v Dataset version (optional)
   * @param external Document or collection (optional)
   * @param file File (optional)
   * @return UploadResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The imported result </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UploadResponse uploadDataset(String client, String project, String artifact, String identity, String v, String external, File file) throws ApiException {
    return uploadDatasetWithHttpInfo(client, project, artifact, identity, v, external, file).getData();
  }

  /**
   * Import datasets
   * Import datasets
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Dataset name (required)
   * @param identity Unique row identifier (key) (required)
   * @param v Dataset version (optional)
   * @param external Document or collection (optional)
   * @param file File (optional)
   * @return ApiResponse&lt;UploadResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The imported result </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> Version Conflict </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UploadResponse> uploadDatasetWithHttpInfo(String client, String project, String artifact, String identity, String v, String external, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling uploadDataset");
    }
    
    // verify the required parameter 'project' is set
    if (project == null) {
      throw new ApiException(400, "Missing the required parameter 'project' when calling uploadDataset");
    }
    
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
      throw new ApiException(400, "Missing the required parameter 'artifact' when calling uploadDataset");
    }
    
    // verify the required parameter 'identity' is set
    if (identity == null) {
      throw new ApiException(400, "Missing the required parameter 'identity' when calling uploadDataset");
    }
    
    // create path and map variables
    String localVarPath = "/data/{client}/{project}/{artifact}/import"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "project" + "\\}", apiClient.escapeString(project.toString()))
      .replaceAll("\\{" + "artifact" + "\\}", apiClient.escapeString(artifact.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "v", v));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "identity", identity));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "external", external));

    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UploadResponse> localVarReturnType = new GenericType<UploadResponse>() {};
    return apiClient.invokeAPI("DataServicesApi.uploadDataset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
