package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import java.io.File;
import io.logicdrop.openapi.models.FileResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ContentServicesApi {
  private ApiClient apiClient;

  public ContentServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ContentServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Delete content
   * Delete a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The deleted files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> deleteContent(String client, String folders, String filename, String extension) throws ApiException {
    return deleteContentWithHttpInfo(client, folders, filename, extension).getData();
  }

  /**
   * Delete content
   * Delete a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The deleted files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> deleteContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deleteContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling deleteContent");
    }
    
    // verify the required parameter 'filename' is set
    if (filename == null) {
      throw new ApiException(400, "Missing the required parameter 'filename' when calling deleteContent");
    }
    
    // verify the required parameter 'extension' is set
    if (extension == null) {
      throw new ApiException(400, "Missing the required parameter 'extension' when calling deleteContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/{folders}/{filename}.{extension}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()))
      .replaceAll("\\{" + "filename" + "\\}", apiClient.escapeString(filename.toString()))
      .replaceAll("\\{" + "extension" + "\\}", apiClient.escapeString(extension.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.deleteContent", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Delete private content
   * Delete a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The deleted files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> deletePrivateContent(String client, String folders, String filename, String extension) throws ApiException {
    return deletePrivateContentWithHttpInfo(client, folders, filename, extension).getData();
  }

  /**
   * Delete private content
   * Delete a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The deleted files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> deletePrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling deletePrivateContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling deletePrivateContent");
    }
    
    // verify the required parameter 'filename' is set
    if (filename == null) {
      throw new ApiException(400, "Missing the required parameter 'filename' when calling deletePrivateContent");
    }
    
    // verify the required parameter 'extension' is set
    if (extension == null) {
      throw new ApiException(400, "Missing the required parameter 'extension' when calling deletePrivateContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()))
      .replaceAll("\\{" + "filename" + "\\}", apiClient.escapeString(filename.toString()))
      .replaceAll("\\{" + "extension" + "\\}", apiClient.escapeString(extension.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.deletePrivateContent", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get content
   * Get a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The file </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void getContent(String client, String folders, String filename, String extension) throws ApiException {
    getContentWithHttpInfo(client, folders, filename, extension);
  }

  /**
   * Get content
   * Get a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The file </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> getContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling getContent");
    }
    
    // verify the required parameter 'filename' is set
    if (filename == null) {
      throw new ApiException(400, "Missing the required parameter 'filename' when calling getContent");
    }
    
    // verify the required parameter 'extension' is set
    if (extension == null) {
      throw new ApiException(400, "Missing the required parameter 'extension' when calling getContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/{folders}/{filename}.{extension}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()))
      .replaceAll("\\{" + "filename" + "\\}", apiClient.escapeString(filename.toString()))
      .replaceAll("\\{" + "extension" + "\\}", apiClient.escapeString(extension.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/octet-stream"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("ContentServicesApi.getContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Get private content
   * Get a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The file </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public void getPrivateContent(String client, String folders, String filename, String extension) throws ApiException {
    getPrivateContentWithHttpInfo(client, folders, filename, extension);
  }

  /**
   * Get private content
   * Get a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The file </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Void> getPrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getPrivateContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling getPrivateContent");
    }
    
    // verify the required parameter 'filename' is set
    if (filename == null) {
      throw new ApiException(400, "Missing the required parameter 'filename' when calling getPrivateContent");
    }
    
    // verify the required parameter 'extension' is set
    if (extension == null) {
      throw new ApiException(400, "Missing the required parameter 'extension' when calling getPrivateContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()))
      .replaceAll("\\{" + "filename" + "\\}", apiClient.escapeString(filename.toString()))
      .replaceAll("\\{" + "extension" + "\\}", apiClient.escapeString(extension.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/octet-stream"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    
    return apiClient.invokeAPI("ContentServicesApi.getPrivateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Get signed token
   * Get a signed token for uploading or downloading directly
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @param expires Expiration (optional)
   * @param _public Private or public origin (default false) (optional)
   * @param upload URL for uploading (optional)
   * @return FileResult
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The signed url </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public FileResult getSignedToken(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws ApiException {
    return getSignedTokenWithHttpInfo(client, folders, filename, extension, expires, _public, upload).getData();
  }

  /**
   * Get signed token
   * Get a signed token for uploading or downloading directly
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @param expires Expiration (optional)
   * @param _public Private or public origin (default false) (optional)
   * @param upload URL for uploading (optional)
   * @return ApiResponse&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The signed url </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<FileResult> getSignedTokenWithHttpInfo(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getSignedToken");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling getSignedToken");
    }
    
    // verify the required parameter 'filename' is set
    if (filename == null) {
      throw new ApiException(400, "Missing the required parameter 'filename' when calling getSignedToken");
    }
    
    // verify the required parameter 'extension' is set
    if (extension == null) {
      throw new ApiException(400, "Missing the required parameter 'extension' when calling getSignedToken");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/signed/{folders}/{filename}.{extension}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()))
      .replaceAll("\\{" + "filename" + "\\}", apiClient.escapeString(filename.toString()))
      .replaceAll("\\{" + "extension" + "\\}", apiClient.escapeString(extension.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "expires", expires));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "public", _public));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "upload", upload));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<FileResult> localVarReturnType = new GenericType<FileResult>() {};
    return apiClient.invokeAPI("ContentServicesApi.getSignedToken", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List contents
   * List files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The listed files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> listContent(String client, String folders) throws ApiException {
    return listContentWithHttpInfo(client, folders).getData();
  }

  /**
   * List contents
   * List files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The listed files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> listContentWithHttpInfo(String client, String folders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling listContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/{folders}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.listContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List private contents
   * List private files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param recursive Include subfolders (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The listed files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> listPrivateContent(String client, String folders, String recursive) throws ApiException {
    return listPrivateContentWithHttpInfo(client, folders, recursive).getData();
  }

  /**
   * List private contents
   * List private files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param recursive Include subfolders (optional)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The listed files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> listPrivateContentWithHttpInfo(String client, String folders, String recursive) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listPrivateContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling listPrivateContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/private/{folders}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "recursive", recursive));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.listPrivateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Upload content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> uploadContent(String client, String folders, String explode, String unique, File file) throws ApiException {
    return uploadContentWithHttpInfo(client, folders, explode, unique, file).getData();
  }

  /**
   * Upload content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> uploadContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling uploadContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/{folders}/upload"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "explode", explode));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "unique", unique));

    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.uploadContent", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Upload private content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<FileResult> uploadPrivateContent(String client, String folders, String explode, String unique, File file) throws ApiException {
    return uploadPrivateContentWithHttpInfo(client, folders, explode, unique, file).getData();
  }

  /**
   * Upload private content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return ApiResponse&lt;List&lt;FileResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> The uploaded files </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<FileResult>> uploadPrivateContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling uploadPrivateContent");
    }
    
    // verify the required parameter 'folders' is set
    if (folders == null) {
      throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadPrivateContent");
    }
    
    // create path and map variables
    String localVarPath = "/content/{client}/private/{folders}/upload"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "folders" + "\\}", apiClient.escapeString(folders.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "explode", explode));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "unique", unique));

    
    
    if (file != null)
      localVarFormParams.put("file", file);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>() {};
    return apiClient.invokeAPI("ContentServicesApi.uploadPrivateContent", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
