/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.GenerateTemplateRequest;
import io.logicdrop.openapi.models.InlineResponse200;
import io.logicdrop.openapi.models.Template;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateTemplateResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class TemplateServicesApi {
    private ApiClient apiClient;

    public TemplateServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplateServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ArtifactResponse deleteTemplate(String client, String project, String artifact, String v) throws ApiException {
        return this.deleteTemplateWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ArtifactResponse> deleteTemplateWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteTemplate");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteTemplate");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteTemplate");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.deleteTemplate", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteTemplates(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteTemplatesWithHttpInfo(client, project, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteTemplatesWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteTemplates");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteTemplates");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteTemplates");
        }
        String localVarPath = "/templates/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.deleteTemplates", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineResponse200 generateTemplate(String client, String project, String artifact, String v, GenerateTemplateRequest generateTemplateRequest) throws ApiException {
        return this.generateTemplateWithHttpInfo(client, project, artifact, v, generateTemplateRequest).getData();
    }

    public ApiResponse<InlineResponse200> generateTemplateWithHttpInfo(String client, String project, String artifact, String v, GenerateTemplateRequest generateTemplateRequest) throws ApiException {
        GenerateTemplateRequest localVarPostBody = generateTemplateRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling generateTemplate");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling generateTemplate");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling generateTemplate");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}/generate".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.generateTemplate", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Template getTemplate(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getTemplateWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<Template> getTemplateWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getTemplate");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getTemplate");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getTemplate");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Template> localVarReturnType = new GenericType<Template>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.getTemplate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getTemplateContent(String client, String project, String artifact, String v) throws ApiException {
        return this.getTemplateContentWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<String> getTemplateContentWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getTemplateContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getTemplateContent");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getTemplateContent");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.getTemplateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Template> listTemplates(String client, String project, List<String> view) throws ApiException {
        return this.listTemplatesWithHttpInfo(client, project, view).getData();
    }

    public ApiResponse<List<Template>> listTemplatesWithHttpInfo(String client, String project, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listTemplates");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listTemplates");
        }
        String localVarPath = "/templates/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Template>> localVarReturnType = new GenericType<List<Template>>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.listTemplates", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Template saveTemplate(String client, String project, Template template) throws ApiException {
        return this.saveTemplateWithHttpInfo(client, project, template).getData();
    }

    public ApiResponse<Template> saveTemplateWithHttpInfo(String client, String project, Template template) throws ApiException {
        Template localVarPostBody = template;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveTemplate");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveTemplate");
        }
        if (template == null) {
            throw new ApiException(400, "Missing the required parameter 'template' when calling saveTemplate");
        }
        String localVarPath = "/templates/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Template> localVarReturnType = new GenericType<Template>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.saveTemplate", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateTemplate(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateTemplateWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateTemplateWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplate");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplate");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplate");
        }
        String localVarPath = "/templates/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.updateTemplate", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateTemplateResponse updateTemplateContentFile(String client, String project, String artifact, String v, File file) throws ApiException {
        return this.updateTemplateContentFileWithHttpInfo(client, project, artifact, v, file).getData();
    }

    public ApiResponse<UpdateTemplateResponse> updateTemplateContentFileWithHttpInfo(String client, String project, String artifact, String v, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplateContentFile");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplateContentFile");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateTemplateContentFile");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UpdateTemplateResponse> localVarReturnType = new GenericType<UpdateTemplateResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.updateTemplateContentFile", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateTemplateResponse updateTemplateContentText(String client, String project, String artifact, String v, String body) throws ApiException {
        return this.updateTemplateContentTextWithHttpInfo(client, project, artifact, v, body).getData();
    }

    public ApiResponse<UpdateTemplateResponse> updateTemplateContentTextWithHttpInfo(String client, String project, String artifact, String v, String body) throws ApiException {
        String localVarPostBody = body;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplateContentText");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplateContentText");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateTemplateContentText");
        }
        String localVarPath = "/templates/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UpdateTemplateResponse> localVarReturnType = new GenericType<UpdateTemplateResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.updateTemplateContentText", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateTemplates(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateTemplatesWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateTemplatesWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateTemplates");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateTemplates");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplates");
        }
        String localVarPath = "/templates/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("TemplateServicesApi.updateTemplates", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

