/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.FileResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class OfficeServicesApi {
    private ApiClient apiClient;

    public OfficeServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OfficeServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<FileResult> uploadDocuments(String client, String project, String source, String to, String unique, File file) throws ApiException {
        return this.uploadDocumentsWithHttpInfo(client, project, source, to, unique, file).getData();
    }

    public ApiResponse<List<FileResult>> uploadDocumentsWithHttpInfo(String client, String project, String source, String to, String unique, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadDocuments");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling uploadDocuments");
        }
        if (source == null) {
            throw new ApiException(400, "Missing the required parameter 'source' when calling uploadDocuments");
        }
        if (to == null) {
            throw new ApiException(400, "Missing the required parameter 'to' when calling uploadDocuments");
        }
        String localVarPath = "/office/{client}/{project}/documents/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString())).replaceAll("\\{to\\}", this.apiClient.escapeString(to.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unique", unique));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("OfficeServicesApi.uploadDocuments", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

