/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.EmailMessage;
import io.logicdrop.openapi.models.EmailResult;
import io.logicdrop.openapi.models.EmailWithAttachment;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class EmailServicesApi {
    private ApiClient apiClient;

    public EmailServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EmailResult sendEmail(String client, EmailMessage emailMessage) throws ApiException {
        return this.sendEmailWithHttpInfo(client, emailMessage).getData();
    }

    public ApiResponse<EmailResult> sendEmailWithHttpInfo(String client, EmailMessage emailMessage) throws ApiException {
        EmailMessage localVarPostBody = emailMessage;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling sendEmail");
        }
        if (emailMessage == null) {
            throw new ApiException(400, "Missing the required parameter 'emailMessage' when calling sendEmail");
        }
        String localVarPath = "/email/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<EmailResult> localVarReturnType = new GenericType<EmailResult>(){};
        return this.apiClient.invokeAPI("EmailServicesApi.sendEmail", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailResult sendWithAttachment(String client, EmailWithAttachment emailWithAttachment) throws ApiException {
        return this.sendWithAttachmentWithHttpInfo(client, emailWithAttachment).getData();
    }

    public ApiResponse<EmailResult> sendWithAttachmentWithHttpInfo(String client, EmailWithAttachment emailWithAttachment) throws ApiException {
        EmailWithAttachment localVarPostBody = emailWithAttachment;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling sendWithAttachment");
        }
        if (emailWithAttachment == null) {
            throw new ApiException(400, "Missing the required parameter 'emailWithAttachment' when calling sendWithAttachment");
        }
        String localVarPath = "/email/{client}/send".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<EmailResult> localVarReturnType = new GenericType<EmailResult>(){};
        return this.apiClient.invokeAPI("EmailServicesApi.sendWithAttachment", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

