/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.Archive;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.Dataset;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.ExternalSource;
import io.logicdrop.openapi.models.SaveContentRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateDataRequest;
import io.logicdrop.openapi.models.UploadResponse;
import io.logicdrop.openapi.models.UserData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class DataServicesApi {
    private ApiClient apiClient;

    public DataServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Archive archiveDataset(String client, String project, String artifact, String v) throws ApiException {
        return this.archiveDatasetWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<Archive> archiveDatasetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling archiveDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling archiveDataset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling archiveDataset");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/archives".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Archive> localVarReturnType = new GenericType<Archive>(){};
        return this.apiClient.invokeAPI("DataServicesApi.archiveDataset", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Archive archiveRecord(String client, String project, String artifact, String id, String v) throws ApiException {
        return this.archiveRecordWithHttpInfo(client, project, artifact, id, v).getData();
    }

    public ApiResponse<Archive> archiveRecordWithHttpInfo(String client, String project, String artifact, String id, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling archiveRecord");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling archiveRecord");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling archiveRecord");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling archiveRecord");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}/archives".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Archive> localVarReturnType = new GenericType<Archive>(){};
        return this.apiClient.invokeAPI("DataServicesApi.archiveRecord", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteDataset(String client, String project, String artifact, String v) throws ApiException {
        return this.deleteDatasetWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ArtifactResponse> deleteDatasetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteDataset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteDataset");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.deleteDataset", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteDatasets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteDatasetsWithHttpInfo(client, project, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteDatasetsWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteDatasets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteDatasets");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteDatasets");
        }
        String localVarPath = "/data/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.deleteDatasets", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResponse deleteRecord(String client, String project, String artifact, String id, String v) throws ApiException {
        return this.deleteRecordWithHttpInfo(client, project, artifact, id, v).getData();
    }

    public ApiResponse<DataResponse> deleteRecordWithHttpInfo(String client, String project, String artifact, String id, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRecord");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRecord");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRecord");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteRecord");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.deleteRecord", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResponse deleteRecords(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
        return this.deleteRecordsWithHttpInfo(client, project, artifact, deleteDataRequest, v).getData();
    }

    public ApiResponse<DataResponse> deleteRecordsWithHttpInfo(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
        DeleteDataRequest localVarPostBody = deleteDataRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRecords");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRecords");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRecords");
        }
        if (deleteDataRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteDataRequest' when calling deleteRecords");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.deleteRecords", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Dataset getDataset(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getDatasetWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<Dataset> getDatasetWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getDataset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getDataset");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Dataset> localVarReturnType = new GenericType<Dataset>(){};
        return this.apiClient.invokeAPI("DataServicesApi.getDataset", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object getDatasetContent(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getDatasetContentWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<Object> getDatasetContentWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getDatasetContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getDatasetContent");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getDatasetContent");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("DataServicesApi.getDatasetContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserData getRecord(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
        return this.getRecordWithHttpInfo(client, project, artifact, id, v, view).getData();
    }

    public ApiResponse<UserData> getRecordWithHttpInfo(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRecord");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRecord");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRecord");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRecord");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("DataServicesApi.getRecord", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Archive> listDatasetArchives(String client, String project, String artifact) throws ApiException {
        return this.listDatasetArchivesWithHttpInfo(client, project, artifact).getData();
    }

    public ApiResponse<List<Archive>> listDatasetArchivesWithHttpInfo(String client, String project, String artifact) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listDatasetArchives");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listDatasetArchives");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listDatasetArchives");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/archives".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Archive>> localVarReturnType = new GenericType<List<Archive>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listDatasetArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Dataset> listDatasets(String client, String project, List<String> view) throws ApiException {
        return this.listDatasetsWithHttpInfo(client, project, view).getData();
    }

    public ApiResponse<List<Dataset>> listDatasetsWithHttpInfo(String client, String project, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listDatasets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listDatasets");
        }
        String localVarPath = "/data/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Dataset>> localVarReturnType = new GenericType<List<Dataset>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listDatasets", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Archive> listRecordArchives(String client, String project, String artifact, String id) throws ApiException {
        return this.listRecordArchivesWithHttpInfo(client, project, artifact, id).getData();
    }

    public ApiResponse<List<Archive>> listRecordArchivesWithHttpInfo(String client, String project, String artifact, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRecordArchives");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRecordArchives");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecordArchives");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listRecordArchives");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows/{id}/archives".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Archive>> localVarReturnType = new GenericType<List<Archive>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listRecordArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserData> listRecords(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws ApiException {
        return this.listRecordsWithHttpInfo(client, project, artifact, v, criteria, fields, value, view, filter, order, tags, ignoreCase, limit).getData();
    }

    public ApiResponse<List<UserData>> listRecordsWithHttpInfo(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRecords");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRecords");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecords");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "criteria", criteria));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "value", value));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ignoreCase", ignoreCase));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<UserData>> localVarReturnType = new GenericType<List<UserData>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listRecords", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserData> listRecordsBy(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
        return this.listRecordsByWithHttpInfo(client, project, artifact, key, value, v, view).getData();
    }

    public ApiResponse<List<UserData>> listRecordsByWithHttpInfo(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRecordsBy");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRecordsBy");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRecordsBy");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling listRecordsBy");
        }
        if (value == null) {
            throw new ApiException(400, "Missing the required parameter 'value' when calling listRecordsBy");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows/by/{key}/{value}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString())).replaceAll("\\{value\\}", this.apiClient.escapeString(value.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<UserData>> localVarReturnType = new GenericType<List<UserData>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listRecordsBy", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ExternalSource> listSources(String client, String check) throws ApiException {
        return this.listSourcesWithHttpInfo(client, check).getData();
    }

    public ApiResponse<List<ExternalSource>> listSourcesWithHttpInfo(String client, String check) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listSources");
        }
        String localVarPath = "/data/{client}/sources".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "check", check));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<ExternalSource>> localVarReturnType = new GenericType<List<ExternalSource>>(){};
        return this.apiClient.invokeAPI("DataServicesApi.listSources", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Dataset saveDataset(String client, String project, Dataset dataset) throws ApiException {
        return this.saveDatasetWithHttpInfo(client, project, dataset).getData();
    }

    public ApiResponse<Dataset> saveDatasetWithHttpInfo(String client, String project, Dataset dataset) throws ApiException {
        Dataset localVarPostBody = dataset;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveDataset");
        }
        if (dataset == null) {
            throw new ApiException(400, "Missing the required parameter 'dataset' when calling saveDataset");
        }
        String localVarPath = "/data/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Dataset> localVarReturnType = new GenericType<Dataset>(){};
        return this.apiClient.invokeAPI("DataServicesApi.saveDataset", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object saveDatasetContent(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws ApiException {
        return this.saveDatasetContentWithHttpInfo(client, project, artifact, saveContentRequest, v).getData();
    }

    public ApiResponse<Object> saveDatasetContentWithHttpInfo(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws ApiException {
        SaveContentRequest localVarPostBody = saveContentRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveDatasetContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveDatasetContent");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveDatasetContent");
        }
        if (saveContentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'saveContentRequest' when calling saveDatasetContent");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("DataServicesApi.saveDatasetContent", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserData saveRecord(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws ApiException {
        return this.saveRecordWithHttpInfo(client, project, artifact, requestBody, v).getData();
    }

    public ApiResponse<UserData> saveRecordWithHttpInfo(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws ApiException {
        Map<String, Object> localVarPostBody = requestBody;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveRecord");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveRecord");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveRecord");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling saveRecord");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("DataServicesApi.saveRecord", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateDataset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateDatasetWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateDatasetWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateDataset");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateDataset");
        }
        String localVarPath = "/data/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.updateDataset", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object updateDatasetContent(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        return this.updateDatasetContentWithHttpInfo(client, project, artifact, updateDataRequest, v).getData();
    }

    public ApiResponse<Object> updateDatasetContentWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        UpdateDataRequest localVarPostBody = updateDataRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasetContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasetContent");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateDatasetContent");
        }
        if (updateDataRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContent");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("DataServicesApi.updateDatasetContent", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object updateDatasetContentAt(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        return this.updateDatasetContentAtWithHttpInfo(client, project, artifact, index, updateDataRequest, v).getData();
    }

    public ApiResponse<Object> updateDatasetContentAtWithHttpInfo(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        UpdateDataRequest localVarPostBody = updateDataRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasetContentAt");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasetContentAt");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateDatasetContentAt");
        }
        if (index == null) {
            throw new ApiException(400, "Missing the required parameter 'index' when calling updateDatasetContentAt");
        }
        if (updateDataRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContentAt");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/content/{index}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("DataServicesApi.updateDatasetContentAt", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateDatasets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateDatasetsWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateDatasetsWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateDatasets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateDatasets");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateDatasets");
        }
        String localVarPath = "/data/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.updateDatasets", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResponse updateRecords(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        return this.updateRecordsWithHttpInfo(client, project, artifact, updateDataRequest, v).getData();
    }

    public ApiResponse<DataResponse> updateRecordsWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws ApiException {
        UpdateDataRequest localVarPostBody = updateDataRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRecords");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRecords");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRecords");
        }
        if (updateDataRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateDataRequest' when calling updateRecords");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/rows".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.updateRecords", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UploadResponse uploadDataset(String client, String project, String artifact, String identity, String v, String external, File file) throws ApiException {
        return this.uploadDatasetWithHttpInfo(client, project, artifact, identity, v, external, file).getData();
    }

    public ApiResponse<UploadResponse> uploadDatasetWithHttpInfo(String client, String project, String artifact, String identity, String v, String external, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadDataset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling uploadDataset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling uploadDataset");
        }
        if (identity == null) {
            throw new ApiException(400, "Missing the required parameter 'identity' when calling uploadDataset");
        }
        String localVarPath = "/data/{client}/{project}/{artifact}/import".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity", identity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "external", external));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UploadResponse> localVarReturnType = new GenericType<UploadResponse>(){};
        return this.apiClient.invokeAPI("DataServicesApi.uploadDataset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

