/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.FileResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class ContentServicesApi {
    private ApiClient apiClient;

    public ContentServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<FileResult> deleteContent(String client, String folders, String filename, String extension) throws ApiException {
        return this.deleteContentWithHttpInfo(client, folders, filename, extension).getData();
    }

    public ApiResponse<List<FileResult>> deleteContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling deleteContent");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling deleteContent");
        }
        if (extension == null) {
            throw new ApiException(400, "Missing the required parameter 'extension' when calling deleteContent");
        }
        String localVarPath = "/content/{client}/{folders}/{filename}.{extension}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString())).replaceAll("\\{filename\\}", this.apiClient.escapeString(filename.toString())).replaceAll("\\{extension\\}", this.apiClient.escapeString(extension.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.deleteContent", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileResult> deletePrivateContent(String client, String folders, String filename, String extension) throws ApiException {
        return this.deletePrivateContentWithHttpInfo(client, folders, filename, extension).getData();
    }

    public ApiResponse<List<FileResult>> deletePrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deletePrivateContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling deletePrivateContent");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling deletePrivateContent");
        }
        if (extension == null) {
            throw new ApiException(400, "Missing the required parameter 'extension' when calling deletePrivateContent");
        }
        String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString())).replaceAll("\\{filename\\}", this.apiClient.escapeString(filename.toString())).replaceAll("\\{extension\\}", this.apiClient.escapeString(extension.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.deletePrivateContent", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getContent(String client, String folders, String filename, String extension) throws ApiException {
        this.getContentWithHttpInfo(client, folders, filename, extension);
    }

    public ApiResponse<Void> getContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling getContent");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling getContent");
        }
        if (extension == null) {
            throw new ApiException(400, "Missing the required parameter 'extension' when calling getContent");
        }
        String localVarPath = "/content/{client}/{folders}/{filename}.{extension}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString())).replaceAll("\\{filename\\}", this.apiClient.escapeString(filename.toString())).replaceAll("\\{extension\\}", this.apiClient.escapeString(extension.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        return this.apiClient.invokeAPI("ContentServicesApi.getContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void getPrivateContent(String client, String folders, String filename, String extension) throws ApiException {
        this.getPrivateContentWithHttpInfo(client, folders, filename, extension);
    }

    public ApiResponse<Void> getPrivateContentWithHttpInfo(String client, String folders, String filename, String extension) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getPrivateContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling getPrivateContent");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling getPrivateContent");
        }
        if (extension == null) {
            throw new ApiException(400, "Missing the required parameter 'extension' when calling getPrivateContent");
        }
        String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString())).replaceAll("\\{filename\\}", this.apiClient.escapeString(filename.toString())).replaceAll("\\{extension\\}", this.apiClient.escapeString(extension.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        return this.apiClient.invokeAPI("ContentServicesApi.getPrivateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public FileResult getSignedToken(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws ApiException {
        return this.getSignedTokenWithHttpInfo(client, folders, filename, extension, expires, _public, upload).getData();
    }

    public ApiResponse<FileResult> getSignedTokenWithHttpInfo(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getSignedToken");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling getSignedToken");
        }
        if (filename == null) {
            throw new ApiException(400, "Missing the required parameter 'filename' when calling getSignedToken");
        }
        if (extension == null) {
            throw new ApiException(400, "Missing the required parameter 'extension' when calling getSignedToken");
        }
        String localVarPath = "/content/{client}/signed/{folders}/{filename}.{extension}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString())).replaceAll("\\{filename\\}", this.apiClient.escapeString(filename.toString())).replaceAll("\\{extension\\}", this.apiClient.escapeString(extension.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "expires", expires));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "public", _public));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "upload", upload));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<FileResult> localVarReturnType = new GenericType<FileResult>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.getSignedToken", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileResult> listContent(String client, String folders) throws ApiException {
        return this.listContentWithHttpInfo(client, folders).getData();
    }

    public ApiResponse<List<FileResult>> listContentWithHttpInfo(String client, String folders) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling listContent");
        }
        String localVarPath = "/content/{client}/{folders}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.listContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileResult> listPrivateContent(String client, String folders, String recursive) throws ApiException {
        return this.listPrivateContentWithHttpInfo(client, folders, recursive).getData();
    }

    public ApiResponse<List<FileResult>> listPrivateContentWithHttpInfo(String client, String folders, String recursive) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listPrivateContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling listPrivateContent");
        }
        String localVarPath = "/content/{client}/private/{folders}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "recursive", recursive));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.listPrivateContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileResult> uploadContent(String client, String folders, String explode, String unique, File file) throws ApiException {
        return this.uploadContentWithHttpInfo(client, folders, explode, unique, file).getData();
    }

    public ApiResponse<List<FileResult>> uploadContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadContent");
        }
        String localVarPath = "/content/{client}/{folders}/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "explode", explode));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unique", unique));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.uploadContent", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileResult> uploadPrivateContent(String client, String folders, String explode, String unique, File file) throws ApiException {
        return this.uploadPrivateContentWithHttpInfo(client, folders, explode, unique, file).getData();
    }

    public ApiResponse<List<FileResult>> uploadPrivateContentWithHttpInfo(String client, String folders, String explode, String unique, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadPrivateContent");
        }
        if (folders == null) {
            throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadPrivateContent");
        }
        String localVarPath = "/content/{client}/private/{folders}/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{folders\\}", this.apiClient.escapeString(folders.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "explode", explode));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unique", unique));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<FileResult>> localVarReturnType = new GenericType<List<FileResult>>(){};
        return this.apiClient.invokeAPI("ContentServicesApi.uploadPrivateContent", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

