/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.Client;
import io.logicdrop.openapi.models.DataResult;
import io.logicdrop.openapi.models.IdentityApplication;
import io.logicdrop.openapi.models.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class ClientServicesApi {
    private ApiClient apiClient;

    public ClientServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClientServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IdentityApplication createApplication(String client, IdentityApplication identityApplication) throws ApiException {
        return this.createApplicationWithHttpInfo(client, identityApplication).getData();
    }

    public ApiResponse<IdentityApplication> createApplicationWithHttpInfo(String client, IdentityApplication identityApplication) throws ApiException {
        IdentityApplication localVarPostBody = identityApplication;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling createApplication");
        }
        if (identityApplication == null) {
            throw new ApiException(400, "Missing the required parameter 'identityApplication' when calling createApplication");
        }
        String localVarPath = "/clients/{client}/applications".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<IdentityApplication> localVarReturnType = new GenericType<IdentityApplication>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.createApplication", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Client deleteApplication(String client, String id) throws ApiException {
        return this.deleteApplicationWithHttpInfo(client, id).getData();
    }

    public ApiResponse<Client> deleteApplicationWithHttpInfo(String client, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteApplication");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteApplication");
        }
        String localVarPath = "/clients/{client}/applications/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Client> localVarReturnType = new GenericType<Client>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.deleteApplication", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResult deleteClient(String client) throws ApiException {
        return this.deleteClientWithHttpInfo(client).getData();
    }

    public ApiResponse<DataResult> deleteClientWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteClient");
        }
        String localVarPath = "/clients/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResult> localVarReturnType = new GenericType<DataResult>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.deleteClient", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Client deleteUser(String client, String email) throws ApiException {
        return this.deleteUserWithHttpInfo(client, email).getData();
    }

    public ApiResponse<Client> deleteUserWithHttpInfo(String client, String email) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteUser");
        }
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling deleteUser");
        }
        String localVarPath = "/clients/{client}/users".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", email));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Client> localVarReturnType = new GenericType<Client>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.deleteUser", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Client getClient(String client) throws ApiException {
        return this.getClientWithHttpInfo(client).getData();
    }

    public ApiResponse<Client> getClientWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getClient");
        }
        String localVarPath = "/clients/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Client> localVarReturnType = new GenericType<Client>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.getClient", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getSecret(String client, String id) throws ApiException {
        return this.getSecretWithHttpInfo(client, id).getData();
    }

    public ApiResponse<String> getSecretWithHttpInfo(String client, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getSecret");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSecret");
        }
        String localVarPath = "/clients/{client}/applications/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.getSecret", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Client inviteUser(String client, User user) throws ApiException {
        return this.inviteUserWithHttpInfo(client, user).getData();
    }

    public ApiResponse<Client> inviteUserWithHttpInfo(String client, User user) throws ApiException {
        User localVarPostBody = user;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling inviteUser");
        }
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling inviteUser");
        }
        String localVarPath = "/clients/{client}/users/invite".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Client> localVarReturnType = new GenericType<Client>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.inviteUser", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentityApplication> listApplications(String client) throws ApiException {
        return this.listApplicationsWithHttpInfo(client).getData();
    }

    public ApiResponse<List<IdentityApplication>> listApplicationsWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listApplications");
        }
        String localVarPath = "/clients/{client}/applications".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<IdentityApplication>> localVarReturnType = new GenericType<List<IdentityApplication>>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.listApplications", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Client> listUsers(String client) throws ApiException {
        return this.listUsersWithHttpInfo(client).getData();
    }

    public ApiResponse<List<Client>> listUsersWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listUsers");
        }
        String localVarPath = "/clients/{client}/users".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Client>> localVarReturnType = new GenericType<List<Client>>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.listUsers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void rotateSecret(String client, String id) throws ApiException {
        this.rotateSecretWithHttpInfo(client, id);
    }

    public ApiResponse<Void> rotateSecretWithHttpInfo(String client, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling rotateSecret");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling rotateSecret");
        }
        String localVarPath = "/clients/{client}/applications/{id}/rotate".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        return this.apiClient.invokeAPI("ClientServicesApi.rotateSecret", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Client updateClient(String client, Client model) throws ApiException {
        return this.updateClientWithHttpInfo(client, model).getData();
    }

    public ApiResponse<Client> updateClientWithHttpInfo(String client, Client model) throws ApiException {
        Client localVarPostBody = model;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateClient");
        }
        if (model == null) {
            throw new ApiException(400, "Missing the required parameter 'model' when calling updateClient");
        }
        String localVarPath = "/clients/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Client> localVarReturnType = new GenericType<Client>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.updateClient", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User updateUser(String client, String email, User user) throws ApiException {
        return this.updateUserWithHttpInfo(client, email, user).getData();
    }

    public ApiResponse<User> updateUserWithHttpInfo(String client, String email, User user) throws ApiException {
        User localVarPostBody = user;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateUser");
        }
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling updateUser");
        }
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling updateUser");
        }
        String localVarPath = "/clients/{client}/users".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", email));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI("ClientServicesApi.updateUser", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

