/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.Schema;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SchemaServicesApi {
    private ApiClient apiClient;

    public SchemaServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SchemaServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ArtifactResponse deleteSchema(String client, String project, String artifact, String v) throws ApiException {
        return this.deleteSchemaWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ArtifactResponse> deleteSchemaWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteSchema");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteSchema");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteSchema");
        }
        String localVarPath = "/schemas/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.deleteSchema", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteSchemas(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteSchemasWithHttpInfo(client, project, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteSchemasWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteSchemas");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteSchemas");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteSchemas");
        }
        String localVarPath = "/schemas/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.deleteSchemas", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Schema getSchema(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getSchemaWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<Schema> getSchemaWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getSchema");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getSchema");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getSchema");
        }
        String localVarPath = "/schemas/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Schema> localVarReturnType = new GenericType<Schema>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.getSchema", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Schema> listSchemas(String client, String project, String view) throws ApiException {
        return this.listSchemasWithHttpInfo(client, project, view).getData();
    }

    public ApiResponse<List<Schema>> listSchemasWithHttpInfo(String client, String project, String view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listSchemas");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listSchemas");
        }
        String localVarPath = "/schemas/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Schema>> localVarReturnType = new GenericType<List<Schema>>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.listSchemas", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Schema saveSchema(String client, String project, Schema schema) throws ApiException {
        return this.saveSchemaWithHttpInfo(client, project, schema).getData();
    }

    public ApiResponse<Schema> saveSchemaWithHttpInfo(String client, String project, Schema schema) throws ApiException {
        Schema localVarPostBody = schema;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveSchema");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveSchema");
        }
        if (schema == null) {
            throw new ApiException(400, "Missing the required parameter 'schema' when calling saveSchema");
        }
        String localVarPath = "/schemas/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Schema> localVarReturnType = new GenericType<Schema>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.saveSchema", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateSchema(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateSchemaWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateSchemaWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateSchema");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateSchema");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateSchema");
        }
        String localVarPath = "/schemas/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.updateSchema", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateSchemas(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateSchemasWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateSchemasWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateSchemas");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateSchemas");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateSchemas");
        }
        String localVarPath = "/schemas/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("SchemaServicesApi.updateSchemas", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

