/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.QueryExecuteRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UserQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class QueryServicesApi {
    private ApiClient apiClient;

    public QueryServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ArtifactResponse deleteQueries(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteQueriesWithHttpInfo(client, project, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteQueriesWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteQueries");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteQueries");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteQueries");
        }
        String localVarPath = "/query/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.deleteQueries", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteQuery(String client, String project, String artifact, String v) throws ApiException {
        return this.deleteQueryWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ArtifactResponse> deleteQueryWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteQuery");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteQuery");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteQuery");
        }
        String localVarPath = "/query/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.deleteQuery", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object executeQuery(String client, QueryExecuteRequest queryExecuteRequest) throws ApiException {
        return this.executeQueryWithHttpInfo(client, queryExecuteRequest).getData();
    }

    public ApiResponse<Object> executeQueryWithHttpInfo(String client, QueryExecuteRequest queryExecuteRequest) throws ApiException {
        QueryExecuteRequest localVarPostBody = queryExecuteRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling executeQuery");
        }
        if (queryExecuteRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'queryExecuteRequest' when calling executeQuery");
        }
        String localVarPath = "/query/{client}/execute".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.executeQuery", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserQuery getQuery(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getQueryWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<UserQuery> getQueryWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getQuery");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getQuery");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getQuery");
        }
        String localVarPath = "/query/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserQuery> localVarReturnType = new GenericType<UserQuery>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.getQuery", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserQuery> listQueries(String client, String project, List<String> view) throws ApiException {
        return this.listQueriesWithHttpInfo(client, project, view).getData();
    }

    public ApiResponse<List<UserQuery>> listQueriesWithHttpInfo(String client, String project, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listQueries");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listQueries");
        }
        String localVarPath = "/query/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<UserQuery>> localVarReturnType = new GenericType<List<UserQuery>>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.listQueries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object runQuery(String client, String project, String artifact, String v) throws ApiException {
        return this.runQueryWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<Object> runQueryWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling runQuery");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling runQuery");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling runQuery");
        }
        String localVarPath = "/query/{client}/{project}/{artifact}/run".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.runQuery", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserQuery saveQuery(String client, String project, UserQuery userQuery) throws ApiException {
        return this.saveQueryWithHttpInfo(client, project, userQuery).getData();
    }

    public ApiResponse<UserQuery> saveQueryWithHttpInfo(String client, String project, UserQuery userQuery) throws ApiException {
        UserQuery localVarPostBody = userQuery;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveQuery");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveQuery");
        }
        if (userQuery == null) {
            throw new ApiException(400, "Missing the required parameter 'userQuery' when calling saveQuery");
        }
        String localVarPath = "/query/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserQuery> localVarReturnType = new GenericType<UserQuery>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.saveQuery", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateQueries(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateQueriesWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateQueriesWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateQueries");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateQueries");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateQueries");
        }
        String localVarPath = "/query/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.updateQueries", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateQuery(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateQueryWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateQueryWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateQuery");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateQuery");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateQuery");
        }
        String localVarPath = "/query/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("QueryServicesApi.updateQuery", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

