/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.Archive;
import io.logicdrop.openapi.models.ArtifactReference;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DataResult;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.InlineResponse200;
import io.logicdrop.openapi.models.Project;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class ProjectServicesApi {
    private ApiClient apiClient;

    public ProjectServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DataResult deleteArchive(String client, String project, String id) throws ApiException {
        return this.deleteArchiveWithHttpInfo(client, project, id).getData();
    }

    public ApiResponse<DataResult> deleteArchiveWithHttpInfo(String client, String project, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteArchive");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteArchive");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteArchive");
        }
        String localVarPath = "/projects/{client}/{project}/archives/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResult> localVarReturnType = new GenericType<DataResult>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.deleteArchive", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeleteArtifactRequest deleteProject(String client, String project) throws ApiException {
        return this.deleteProjectWithHttpInfo(client, project).getData();
    }

    public ApiResponse<DeleteArtifactRequest> deleteProjectWithHttpInfo(String client, String project) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteProject");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteProject");
        }
        String localVarPath = "/projects/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DeleteArtifactRequest> localVarReturnType = new GenericType<DeleteArtifactRequest>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.deleteProject", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteProjects(String client, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteProjectsWithHttpInfo(client, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteProjectsWithHttpInfo(String client, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteProjects");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteProjects");
        }
        String localVarPath = "/projects/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.deleteProjects", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Archive getArchive(String client, String project, String id) throws ApiException {
        return this.getArchiveWithHttpInfo(client, project, id).getData();
    }

    public ApiResponse<Archive> getArchiveWithHttpInfo(String client, String project, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getArchive");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getArchive");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getArchive");
        }
        String localVarPath = "/projects/{client}/{project}/archives/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Archive> localVarReturnType = new GenericType<Archive>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.getArchive", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineResponse200 getArchiveContent(String client, String project, String id) throws ApiException {
        return this.getArchiveContentWithHttpInfo(client, project, id).getData();
    }

    public ApiResponse<InlineResponse200> getArchiveContentWithHttpInfo(String client, String project, String id) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getArchiveContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getArchiveContent");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getArchiveContent");
        }
        String localVarPath = "/projects/{client}/{project}/archives/{id}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.getArchiveContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Project getProject(String client, String project) throws ApiException {
        return this.getProjectWithHttpInfo(client, project).getData();
    }

    public ApiResponse<Project> getProjectWithHttpInfo(String client, String project) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getProject");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getProject");
        }
        String localVarPath = "/projects/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Project> localVarReturnType = new GenericType<Project>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.getProject", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Archive> listArchives(String client, String project) throws ApiException {
        return this.listArchivesWithHttpInfo(client, project).getData();
    }

    public ApiResponse<List<Archive>> listArchivesWithHttpInfo(String client, String project) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listArchives");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listArchives");
        }
        String localVarPath = "/projects/{client}/{project}/archives".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Archive>> localVarReturnType = new GenericType<List<Archive>>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.listArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Project> listProjects(String client) throws ApiException {
        return this.listProjectsWithHttpInfo(client).getData();
    }

    public ApiResponse<List<Project>> listProjectsWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listProjects");
        }
        String localVarPath = "/projects/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Project>> localVarReturnType = new GenericType<List<Project>>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.listProjects", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ArtifactReference> listReferences(String client, String project) throws ApiException {
        return this.listReferencesWithHttpInfo(client, project).getData();
    }

    public ApiResponse<List<ArtifactReference>> listReferencesWithHttpInfo(String client, String project) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listReferences");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listReferences");
        }
        String localVarPath = "/projects/{client}/{project}/references".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<ArtifactReference>> localVarReturnType = new GenericType<List<ArtifactReference>>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.listReferences", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Project saveProject(String client, Project model) throws ApiException {
        return this.saveProjectWithHttpInfo(client, model).getData();
    }

    public ApiResponse<Project> saveProjectWithHttpInfo(String client, Project model) throws ApiException {
        Project localVarPostBody = model;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveProject");
        }
        if (model == null) {
            throw new ApiException(400, "Missing the required parameter 'model' when calling saveProject");
        }
        String localVarPath = "/projects/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Project> localVarReturnType = new GenericType<Project>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.saveProject", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateProject(String client, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateProjectWithHttpInfo(client, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateProjectWithHttpInfo(String client, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateProject");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateProject");
        }
        String localVarPath = "/projects/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.updateProject", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateProjects(String client, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateProjectsWithHttpInfo(client, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateProjectsWithHttpInfo(String client, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateProjects");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateProjects");
        }
        String localVarPath = "/projects/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ProjectServicesApi.updateProjects", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

