/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.OperationRequest;
import io.logicdrop.openapi.models.OperationResponse;
import io.logicdrop.openapi.models.OperationTargetResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class PlatformServicesApi {
    private ApiClient apiClient;

    public PlatformServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PlatformServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<OperationTargetResponse> listManagedServices(String service, OperationRequest operationRequest, String data) throws ApiException {
        return this.listManagedServicesWithHttpInfo(service, operationRequest, data).getData();
    }

    public ApiResponse<List<OperationTargetResponse>> listManagedServicesWithHttpInfo(String service, OperationRequest operationRequest, String data) throws ApiException {
        OperationRequest localVarPostBody = operationRequest;
        if (service == null) {
            throw new ApiException(400, "Missing the required parameter 'service' when calling listManagedServices");
        }
        if (operationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'operationRequest' when calling listManagedServices");
        }
        String localVarPath = "/manage/{service}".replaceAll("\\{service\\}", this.apiClient.escapeString(service.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "data", data));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<OperationTargetResponse>> localVarReturnType = new GenericType<List<OperationTargetResponse>>(){};
        return this.apiClient.invokeAPI("PlatformServicesApi.listManagedServices", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OperationResponse manageService(String service, OperationRequest operationRequest) throws ApiException {
        return this.manageServiceWithHttpInfo(service, operationRequest).getData();
    }

    public ApiResponse<OperationResponse> manageServiceWithHttpInfo(String service, OperationRequest operationRequest) throws ApiException {
        OperationRequest localVarPostBody = operationRequest;
        if (service == null) {
            throw new ApiException(400, "Missing the required parameter 'service' when calling manageService");
        }
        if (operationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'operationRequest' when calling manageService");
        }
        String localVarPath = "/manage/{service}".replaceAll("\\{service\\}", this.apiClient.escapeString(service.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<OperationResponse> localVarReturnType = new GenericType<OperationResponse>(){};
        return this.apiClient.invokeAPI("PlatformServicesApi.manageService", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void platformInfo() throws ApiException {
        this.platformInfoWithHttpInfo();
    }

    public ApiResponse<Void> platformInfoWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        return this.apiClient.invokeAPI("PlatformServicesApi.platformInfo", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

