/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.Bundle;
import io.logicdrop.openapi.models.ScaffoldRequest;
import io.logicdrop.openapi.models.ScaffoldResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class PackageServicesApi {
    private ApiClient apiClient;

    public PackageServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PackageServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ArtifactResponse deletePackage(String client, String _package) throws ApiException {
        return this.deletePackageWithHttpInfo(client, _package).getData();
    }

    public ApiResponse<ArtifactResponse> deletePackageWithHttpInfo(String client, String _package) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deletePackage");
        }
        if (_package == null) {
            throw new ApiException(400, "Missing the required parameter '_package' when calling deletePackage");
        }
        String localVarPath = "/packages/{client}/{package}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{package\\}", this.apiClient.escapeString(_package.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.deletePackage", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Bundle getPackage(String client, String _package) throws ApiException {
        return this.getPackageWithHttpInfo(client, _package).getData();
    }

    public ApiResponse<Bundle> getPackageWithHttpInfo(String client, String _package) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getPackage");
        }
        if (_package == null) {
            throw new ApiException(400, "Missing the required parameter '_package' when calling getPackage");
        }
        String localVarPath = "/packages/{client}/{package}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{package\\}", this.apiClient.escapeString(_package.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<Bundle> localVarReturnType = new GenericType<Bundle>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.getPackage", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Bundle> listPackages(String client) throws ApiException {
        return this.listPackagesWithHttpInfo(client).getData();
    }

    public ApiResponse<List<Bundle>> listPackagesWithHttpInfo(String client) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listPackages");
        }
        String localVarPath = "/packages/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Bundle>> localVarReturnType = new GenericType<List<Bundle>>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.listPackages", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScaffoldResponse scaffoldProject(String client, ScaffoldRequest scaffoldRequest) throws ApiException {
        return this.scaffoldProjectWithHttpInfo(client, scaffoldRequest).getData();
    }

    public ApiResponse<ScaffoldResponse> scaffoldProjectWithHttpInfo(String client, ScaffoldRequest scaffoldRequest) throws ApiException {
        ScaffoldRequest localVarPostBody = scaffoldRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling scaffoldProject");
        }
        if (scaffoldRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'scaffoldRequest' when calling scaffoldProject");
        }
        String localVarPath = "/packages/{client}/scaffold".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ScaffoldResponse> localVarReturnType = new GenericType<ScaffoldResponse>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.scaffoldProject", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Bundle> uploadPackage(String client, File file) throws ApiException {
        return this.uploadPackageWithHttpInfo(client, file).getData();
    }

    public ApiResponse<List<Bundle>> uploadPackageWithHttpInfo(String client, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadPackage");
        }
        String localVarPath = "/packages/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<Bundle>> localVarReturnType = new GenericType<List<Bundle>>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.uploadPackage", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScaffoldResponse uploadScaffold(String client, File file) throws ApiException {
        return this.uploadScaffoldWithHttpInfo(client, file).getData();
    }

    public ApiResponse<ScaffoldResponse> uploadScaffoldWithHttpInfo(String client, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadScaffold");
        }
        String localVarPath = "/packages/{client}/scaffold/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ScaffoldResponse> localVarReturnType = new GenericType<ScaffoldResponse>(){};
        return this.apiClient.invokeAPI("PackageServicesApi.uploadScaffold", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

