/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.ActivateRulesetResponse;
import io.logicdrop.openapi.models.AnalyzeRequest;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.ComputeRule;
import io.logicdrop.openapi.models.ComputeRuleset;
import io.logicdrop.openapi.models.ContainerResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.DesignerResult;
import io.logicdrop.openapi.models.GenerateAllRequest;
import io.logicdrop.openapi.models.GenerateOneRequest;
import io.logicdrop.openapi.models.ProcessorRequest;
import io.logicdrop.openapi.models.ProcessorResult;
import io.logicdrop.openapi.models.RuleContainer;
import io.logicdrop.openapi.models.SampleRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateRuleTypesRequest;
import io.logicdrop.openapi.models.UpdateRulesetResponse;
import io.logicdrop.openapi.models.UploadResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class ComputeServicesApi {
    private ApiClient apiClient;

    public ComputeServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ComputeServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ActivateRulesetResponse activateRuleset(String client, String project, String artifact, String v) throws ApiException {
        return this.activateRulesetWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ActivateRulesetResponse> activateRulesetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling activateRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling activateRuleset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling activateRuleset");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/activate".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ActivateRulesetResponse> localVarReturnType = new GenericType<ActivateRulesetResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.activateRuleset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DesignerResult analyzeRuleset(String client, AnalyzeRequest analyzeRequest) throws ApiException {
        return this.analyzeRulesetWithHttpInfo(client, analyzeRequest).getData();
    }

    public ApiResponse<DesignerResult> analyzeRulesetWithHttpInfo(String client, AnalyzeRequest analyzeRequest) throws ApiException {
        AnalyzeRequest localVarPostBody = analyzeRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling analyzeRuleset");
        }
        if (analyzeRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'analyzeRequest' when calling analyzeRuleset");
        }
        String localVarPath = "/compute/{client}/analyze".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DesignerResult> localVarReturnType = new GenericType<DesignerResult>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.analyzeRuleset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ActivateRulesetResponse deactivateRuleset(String client, String project, String artifact, String v) throws ApiException {
        return this.deactivateRulesetWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ActivateRulesetResponse> deactivateRulesetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deactivateRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deactivateRuleset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deactivateRuleset");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/activate".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ActivateRulesetResponse> localVarReturnType = new GenericType<ActivateRulesetResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.deactivateRuleset", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResponse deleteRule(String client, String project, String artifact, String id, String v) throws ApiException {
        return this.deleteRuleWithHttpInfo(client, project, artifact, id, v).getData();
    }

    public ApiResponse<DataResponse> deleteRuleWithHttpInfo(String client, String project, String artifact, String id, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRule");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRule");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRule");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteRule");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.deleteRule", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DataResponse deleteRules(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
        return this.deleteRulesWithHttpInfo(client, project, artifact, deleteDataRequest, v).getData();
    }

    public ApiResponse<DataResponse> deleteRulesWithHttpInfo(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
        DeleteDataRequest localVarPostBody = deleteDataRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRules");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRules");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRules");
        }
        if (deleteDataRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteDataRequest' when calling deleteRules");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DataResponse> localVarReturnType = new GenericType<DataResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.deleteRules", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteRuleset(String client, String project, String artifact, String v) throws ApiException {
        return this.deleteRulesetWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<ArtifactResponse> deleteRulesetWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRuleset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRuleset");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.deleteRuleset", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse deleteRulesets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        return this.deleteRulesetsWithHttpInfo(client, project, deleteArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> deleteRulesetsWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
        DeleteArtifactRequest localVarPostBody = deleteArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRulesets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRulesets");
        }
        if (deleteArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteRulesets");
        }
        String localVarPath = "/compute/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.deleteRulesets", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProcessorResult executeRules(String client, ProcessorRequest processorRequest) throws ApiException {
        return this.executeRulesWithHttpInfo(client, processorRequest).getData();
    }

    public ApiResponse<ProcessorResult> executeRulesWithHttpInfo(String client, ProcessorRequest processorRequest) throws ApiException {
        ProcessorRequest localVarPostBody = processorRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling executeRules");
        }
        if (processorRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'processorRequest' when calling executeRules");
        }
        String localVarPath = "/compute/{client}/execute".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ProcessorResult> localVarReturnType = new GenericType<ProcessorResult>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.executeRules", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String generateRuleset(String client, String project, String artifact, String v, String type) throws ApiException {
        return this.generateRulesetWithHttpInfo(client, project, artifact, v, type).getData();
    }

    public ApiResponse<String> generateRulesetWithHttpInfo(String client, String project, String artifact, String v, String type) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling generateRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling generateRuleset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling generateRuleset");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/generate".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.generateRuleset", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ComputeRule getRule(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
        return this.getRuleWithHttpInfo(client, project, artifact, id, v, view).getData();
    }

    public ApiResponse<ComputeRule> getRuleWithHttpInfo(String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRule");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRule");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRule");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRule");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules/{id}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ComputeRule> localVarReturnType = new GenericType<ComputeRule>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.getRule", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ComputeRuleset getRuleset(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        return this.getRulesetWithHttpInfo(client, project, artifact, v, view).getData();
    }

    public ApiResponse<ComputeRuleset> getRulesetWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRuleset");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRuleset");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ComputeRuleset> localVarReturnType = new GenericType<ComputeRuleset>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.getRuleset", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getRulesetContent(String client, String project, String artifact, String v) throws ApiException {
        return this.getRulesetContentWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<String> getRulesetContentWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetContent");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetContent");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetContent");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.getRulesetContent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getRulesetExample(String client, String project, String artifact, String v) throws ApiException {
        return this.getRulesetExampleWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<String> getRulesetExampleWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetExample");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetExample");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetExample");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/example".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.getRulesetExample", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getRulesetTypes(String client, String project, String artifact, String v) throws ApiException {
        return this.getRulesetTypesWithHttpInfo(client, project, artifact, v).getData();
    }

    public ApiResponse<String> getRulesetTypesWithHttpInfo(String client, String project, String artifact, String v) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetTypes");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetTypes");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetTypes");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/types".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.getRulesetTypes", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContainerResponse listContainers(String client, String project, String ruleset, String status) throws ApiException {
        return this.listContainersWithHttpInfo(client, project, ruleset, status).getData();
    }

    public ApiResponse<ContainerResponse> listContainersWithHttpInfo(String client, String project, String ruleset, String status) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listContainers");
        }
        String localVarPath = "/compute/{client}/containers".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "project", project));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ruleset", ruleset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ContainerResponse> localVarReturnType = new GenericType<ContainerResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.listContainers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ComputeRule> listRules(String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws ApiException {
        return this.listRulesWithHttpInfo(client, project, artifact, v, criteria, type, fields, value, view, filter, order, tags, ignoreCase).getData();
    }

    public ApiResponse<List<ComputeRule>> listRulesWithHttpInfo(String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRules");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRules");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRules");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "criteria", criteria));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "value", value));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ignoreCase", ignoreCase));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<ComputeRule>> localVarReturnType = new GenericType<List<ComputeRule>>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.listRules", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ComputeRule> listRulesBy(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
        return this.listRulesByWithHttpInfo(client, project, artifact, key, value, v, view).getData();
    }

    public ApiResponse<List<ComputeRule>> listRulesByWithHttpInfo(String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRulesBy");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRulesBy");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRulesBy");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling listRulesBy");
        }
        if (value == null) {
            throw new ApiException(400, "Missing the required parameter 'value' when calling listRulesBy");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules/by/{key}/{value}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString())).replaceAll("\\{value\\}", this.apiClient.escapeString(value.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<ComputeRule>> localVarReturnType = new GenericType<List<ComputeRule>>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.listRulesBy", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ComputeRuleset> listRulesets(String client, String project, List<String> view) throws ApiException {
        return this.listRulesetsWithHttpInfo(client, project, view).getData();
    }

    public ApiResponse<List<ComputeRuleset>> listRulesetsWithHttpInfo(String client, String project, List<String> view) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listRulesets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling listRulesets");
        }
        String localVarPath = "/compute/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "view", view));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<ComputeRuleset>> localVarReturnType = new GenericType<List<ComputeRuleset>>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.listRulesets", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RuleContainer manageContainer(String client, String action, RuleContainer ruleContainer) throws ApiException {
        return this.manageContainerWithHttpInfo(client, action, ruleContainer).getData();
    }

    public ApiResponse<RuleContainer> manageContainerWithHttpInfo(String client, String action, RuleContainer ruleContainer) throws ApiException {
        RuleContainer localVarPostBody = ruleContainer;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling manageContainer");
        }
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling manageContainer");
        }
        if (ruleContainer == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleContainer' when calling manageContainer");
        }
        String localVarPath = "/compute/{client}/containers".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "action", action));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<RuleContainer> localVarReturnType = new GenericType<RuleContainer>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.manageContainer", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DesignerResult sampleRuleset(String client, SampleRequest sampleRequest) throws ApiException {
        return this.sampleRulesetWithHttpInfo(client, sampleRequest).getData();
    }

    public ApiResponse<DesignerResult> sampleRulesetWithHttpInfo(String client, SampleRequest sampleRequest) throws ApiException {
        SampleRequest localVarPostBody = sampleRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling sampleRuleset");
        }
        if (sampleRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'sampleRequest' when calling sampleRuleset");
        }
        String localVarPath = "/compute/{client}/sample".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<DesignerResult> localVarReturnType = new GenericType<DesignerResult>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.sampleRuleset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ComputeRule saveRule(String client, String project, String artifact, ComputeRule computeRule, String v) throws ApiException {
        return this.saveRuleWithHttpInfo(client, project, artifact, computeRule, v).getData();
    }

    public ApiResponse<ComputeRule> saveRuleWithHttpInfo(String client, String project, String artifact, ComputeRule computeRule, String v) throws ApiException {
        ComputeRule localVarPostBody = computeRule;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveRule");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveRule");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveRule");
        }
        if (computeRule == null) {
            throw new ApiException(400, "Missing the required parameter 'computeRule' when calling saveRule");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/rules".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ComputeRule> localVarReturnType = new GenericType<ComputeRule>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.saveRule", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ComputeRuleset saveRuleset(String client, String project, ComputeRuleset computeRuleset) throws ApiException {
        return this.saveRulesetWithHttpInfo(client, project, computeRuleset).getData();
    }

    public ApiResponse<ComputeRuleset> saveRulesetWithHttpInfo(String client, String project, ComputeRuleset computeRuleset) throws ApiException {
        ComputeRuleset localVarPostBody = computeRuleset;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling saveRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling saveRuleset");
        }
        if (computeRuleset == null) {
            throw new ApiException(400, "Missing the required parameter 'computeRuleset' when calling saveRuleset");
        }
        String localVarPath = "/compute/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ComputeRuleset> localVarReturnType = new GenericType<ComputeRuleset>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.saveRuleset", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateRuleset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateRulesetWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateRulesetWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRuleset");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRuleset");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateRuleset");
        }
        String localVarPath = "/compute/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRuleset", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateRulesetResponse updateRulesetContentFile(String client, String project, String artifact, String v, File file) throws ApiException {
        return this.updateRulesetContentFileWithHttpInfo(client, project, artifact, v, file).getData();
    }

    public ApiResponse<UpdateRulesetResponse> updateRulesetContentFileWithHttpInfo(String client, String project, String artifact, String v, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetContentFile");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetContentFile");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetContentFile");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UpdateRulesetResponse> localVarReturnType = new GenericType<UpdateRulesetResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRulesetContentFile", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateRulesetResponse updateRulesetContentText(String client, String project, String artifact, String v, String body) throws ApiException {
        return this.updateRulesetContentTextWithHttpInfo(client, project, artifact, v, body).getData();
    }

    public ApiResponse<UpdateRulesetResponse> updateRulesetContentTextWithHttpInfo(String client, String project, String artifact, String v, String body) throws ApiException {
        String localVarPostBody = body;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetContentText");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetContentText");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetContentText");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/content".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UpdateRulesetResponse> localVarReturnType = new GenericType<UpdateRulesetResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRulesetContentText", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateRulesetResponse updateRulesetExample(String client, String project, String artifact, String v, String body) throws ApiException {
        return this.updateRulesetExampleWithHttpInfo(client, project, artifact, v, body).getData();
    }

    public ApiResponse<UpdateRulesetResponse> updateRulesetExampleWithHttpInfo(String client, String project, String artifact, String v, String body) throws ApiException {
        String localVarPostBody = body;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetExample");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetExample");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetExample");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/example".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UpdateRulesetResponse> localVarReturnType = new GenericType<UpdateRulesetResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRulesetExample", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ComputeRuleset updateRulesetTypes(String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws ApiException {
        return this.updateRulesetTypesWithHttpInfo(client, project, artifact, updateRuleTypesRequest, v).getData();
    }

    public ApiResponse<ComputeRuleset> updateRulesetTypesWithHttpInfo(String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws ApiException {
        UpdateRuleTypesRequest localVarPostBody = updateRuleTypesRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetTypes");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetTypes");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetTypes");
        }
        if (updateRuleTypesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateRuleTypesRequest' when calling updateRulesetTypes");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/types".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ComputeRuleset> localVarReturnType = new GenericType<ComputeRuleset>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRulesetTypes", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactResponse updateRulesets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        return this.updateRulesetsWithHttpInfo(client, project, updateArtifactRequest).getData();
    }

    public ApiResponse<ArtifactResponse> updateRulesetsWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
        UpdateArtifactRequest localVarPostBody = updateArtifactRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesets");
        }
        if (updateArtifactRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateRulesets");
        }
        String localVarPath = "/compute/{client}/{project}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<ArtifactResponse> localVarReturnType = new GenericType<ArtifactResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.updateRulesets", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UploadResponse uploadDatasets(String client, String project, File file) throws ApiException {
        return this.uploadDatasetsWithHttpInfo(client, project, file).getData();
    }

    public ApiResponse<UploadResponse> uploadDatasetsWithHttpInfo(String client, String project, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadDatasets");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling uploadDatasets");
        }
        String localVarPath = "/compute/{client}/{project}/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UploadResponse> localVarReturnType = new GenericType<UploadResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.uploadDatasets", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UploadResponse uploadWorkbook(String client, String project, String artifact, String v, Boolean merge, File file) throws ApiException {
        return this.uploadWorkbookWithHttpInfo(client, project, artifact, v, merge, file).getData();
    }

    public ApiResponse<UploadResponse> uploadWorkbookWithHttpInfo(String client, String project, String artifact, String v, Boolean merge, File file) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling uploadWorkbook");
        }
        if (project == null) {
            throw new ApiException(400, "Missing the required parameter 'project' when calling uploadWorkbook");
        }
        if (artifact == null) {
            throw new ApiException(400, "Missing the required parameter 'artifact' when calling uploadWorkbook");
        }
        String localVarPath = "/compute/{client}/{project}/{artifact}/upload".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{project\\}", this.apiClient.escapeString(project.toString())).replaceAll("\\{artifact\\}", this.apiClient.escapeString(artifact.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "v", v));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "merge", merge));
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UploadResponse> localVarReturnType = new GenericType<UploadResponse>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.uploadWorkbook", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String viewRuleset(String client, GenerateAllRequest generateAllRequest) throws ApiException {
        return this.viewRulesetWithHttpInfo(client, generateAllRequest).getData();
    }

    public ApiResponse<String> viewRulesetWithHttpInfo(String client, GenerateAllRequest generateAllRequest) throws ApiException {
        GenerateAllRequest localVarPostBody = generateAllRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling viewRuleset");
        }
        if (generateAllRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'generateAllRequest' when calling viewRuleset");
        }
        String localVarPath = "/compute/{client}/analyze/source".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.viewRuleset", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String viewSource(String client, String typeOrId, GenerateOneRequest generateOneRequest) throws ApiException {
        return this.viewSourceWithHttpInfo(client, typeOrId, generateOneRequest).getData();
    }

    public ApiResponse<String> viewSourceWithHttpInfo(String client, String typeOrId, GenerateOneRequest generateOneRequest) throws ApiException {
        GenerateOneRequest localVarPostBody = generateOneRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling viewSource");
        }
        if (typeOrId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeOrId' when calling viewSource");
        }
        if (generateOneRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'generateOneRequest' when calling viewSource");
        }
        String localVarPath = "/compute/{client}/analyze/source/{typeOrId}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{typeOrId\\}", this.apiClient.escapeString(typeOrId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("ComputeServicesApi.viewSource", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

