/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.models.CacheRequest;
import io.logicdrop.openapi.models.CacheResult;
import io.logicdrop.openapi.models.UserData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class CacheServicesApi {
    private ApiClient apiClient;

    public CacheServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CacheServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserData evictEntry(String client, String cache, String key) throws ApiException {
        return this.evictEntryWithHttpInfo(client, cache, key).getData();
    }

    public ApiResponse<UserData> evictEntryWithHttpInfo(String client, String cache, String key) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling evictEntry");
        }
        if (cache == null) {
            throw new ApiException(400, "Missing the required parameter 'cache' when calling evictEntry");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling evictEntry");
        }
        String localVarPath = "/caches/{client}/{cache}/{key}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{cache\\}", this.apiClient.escapeString(cache.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.evictEntry", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CacheResult flushCache(String client, String cache) throws ApiException {
        return this.flushCacheWithHttpInfo(client, cache).getData();
    }

    public ApiResponse<CacheResult> flushCacheWithHttpInfo(String client, String cache) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling flushCache");
        }
        if (cache == null) {
            throw new ApiException(400, "Missing the required parameter 'cache' when calling flushCache");
        }
        String localVarPath = "/caches/{client}/{cache}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{cache\\}", this.apiClient.escapeString(cache.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<CacheResult> localVarReturnType = new GenericType<CacheResult>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.flushCache", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserData getEntries(String client, String cache) throws ApiException {
        return this.getEntriesWithHttpInfo(client, cache).getData();
    }

    public ApiResponse<UserData> getEntriesWithHttpInfo(String client, String cache) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getEntries");
        }
        if (cache == null) {
            throw new ApiException(400, "Missing the required parameter 'cache' when calling getEntries");
        }
        String localVarPath = "/caches/{client}/{cache}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{cache\\}", this.apiClient.escapeString(cache.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.getEntries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserData getEntry(String client, String cache, String key) throws ApiException {
        return this.getEntryWithHttpInfo(client, cache, key).getData();
    }

    public ApiResponse<UserData> getEntryWithHttpInfo(String client, String cache, String key) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling getEntry");
        }
        if (cache == null) {
            throw new ApiException(400, "Missing the required parameter 'cache' when calling getEntry");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getEntry");
        }
        String localVarPath = "/caches/{client}/{cache}/{key}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{cache\\}", this.apiClient.escapeString(cache.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.getEntry", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<CacheResult> listCaches(String client, String local) throws ApiException {
        return this.listCachesWithHttpInfo(client, local).getData();
    }

    public ApiResponse<List<CacheResult>> listCachesWithHttpInfo(String client, String local) throws ApiException {
        Object localVarPostBody = null;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling listCaches");
        }
        String localVarPath = "/caches/{client}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "local", local));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<List<CacheResult>> localVarReturnType = new GenericType<List<CacheResult>>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.listCaches", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserData putEntry(String client, String cache, CacheRequest cacheRequest) throws ApiException {
        return this.putEntryWithHttpInfo(client, cache, cacheRequest).getData();
    }

    public ApiResponse<UserData> putEntryWithHttpInfo(String client, String cache, CacheRequest cacheRequest) throws ApiException {
        CacheRequest localVarPostBody = cacheRequest;
        if (client == null) {
            throw new ApiException(400, "Missing the required parameter 'client' when calling putEntry");
        }
        if (cache == null) {
            throw new ApiException(400, "Missing the required parameter 'cache' when calling putEntry");
        }
        if (cacheRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'cacheRequest' when calling putEntry");
        }
        String localVarPath = "/caches/{client}/{cache}".replaceAll("\\{client\\}", this.apiClient.escapeString(client.toString())).replaceAll("\\{cache\\}", this.apiClient.escapeString(cache.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        GenericType<UserData> localVarReturnType = new GenericType<UserData>(){};
        return this.apiClient.invokeAPI("CacheServicesApi.putEntry", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

