/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.jersey;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.JSON;
import io.logicdrop.openapi.jersey.Pair;
import io.logicdrop.openapi.jersey.RFC3339DateFormat;
import io.logicdrop.openapi.jersey.ServerConfiguration;
import io.logicdrop.openapi.jersey.ServerVariable;
import io.logicdrop.openapi.jersey.StringUtil;
import io.logicdrop.openapi.jersey.auth.ApiKeyAuth;
import io.logicdrop.openapi.jersey.auth.Authentication;
import io.logicdrop.openapi.jersey.auth.HttpBasicAuth;
import io.logicdrop.openapi.jersey.auth.HttpBearerAuth;
import io.logicdrop.openapi.jersey.auth.OAuth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ApiClient {
    protected Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    protected Map<String, String> defaultCookieMap = new HashMap<String, String>();
    protected String basePath = "https://api.staging.com";
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://api.staging.com", "Staging", new HashMap<String, ServerVariable>()), new ServerConfiguration("https://api.production.com", "Production", new HashMap<String, ServerVariable>())));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    protected Map<String, List<ServerConfiguration>> operationServers = new HashMap<String, List<ServerConfiguration>>(){};
    protected Map<String, Integer> operationServerIndex = new HashMap<String, Integer>();
    protected Map<String, Map<String, String>> operationServerVariables = new HashMap<String, Map<String, String>>();
    protected boolean debugging = false;
    protected int connectionTimeout = 0;
    private int readTimeout = 0;
    protected Client httpClient;
    protected JSON json = new JSON();
    protected String tempFolderPath = null;
    protected Map<String, Authentication> authentications;
    protected Map<String, String> authenticationLookup;
    protected DateFormat dateFormat;

    public ApiClient() {
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new RFC3339DateFormat();
        this.setUserAgent("SparksOpenAPI/4.6.1");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("api", new ApiKeyAuth("header", "X-Logicdrop-ApiKey"));
        this.authentications.put("jwt", new HttpBearerAuth("bearer"));
        this.authentications.put("oauth2", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.authenticationLookup = new HashMap<String, String>();
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void configureApiKeys(HashMap<String, String> secrets) {
        for (Map.Entry<String, Authentication> authEntry : this.authentications.entrySet()) {
            Authentication auth = authEntry.getValue();
            if (!(auth instanceof ApiKeyAuth)) continue;
            String name = authEntry.getKey();
            if (!secrets.containsKey(name = this.authenticationLookup.getOrDefault(name, name))) continue;
            ((ApiKeyAuth)auth).setApiKey(secrets.get(name));
        }
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setBearerToken(String bearerToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)auth).setBearerToken(bearerToken);
            return;
        }
        throw new RuntimeException("No Bearer authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient(debugging);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.httpClient.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) throws ApiException {
        Entity entity;
        if (contentType.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                FormDataContentDisposition contentDisp = FormDataContentDisposition.name((String)param.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, this.parameterToString(param.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = Entity.entity((Object)(obj == null ? Entity.text((Object)"") : obj), (String)contentType);
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (returnType.getRawType() == File.class) {
            File file = this.downloadFileFromResponse(response);
            return (T)file;
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        return (T)response.readEntity(returnType);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ApiResponse<T> invokeAPI(String operation, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        String value;
        String targetURL;
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        if (this.serverIndex != null) {
            void var16_16;
            List<ServerConfiguration> serverConfigurations;
            Integer index;
            if (this.operationServers.containsKey(operation)) {
                index = this.operationServerIndex.getOrDefault(operation, this.serverIndex);
                Map<String, String> map = this.operationServerVariables.getOrDefault(operation, this.serverVariables);
                serverConfigurations = this.operationServers.get(operation);
            } else {
                index = this.serverIndex;
                Map<String, String> map = this.serverVariables;
                serverConfigurations = this.servers;
            }
            if (index < 0 || index >= serverConfigurations.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", index, serverConfigurations.size()));
            }
            targetURL = serverConfigurations.get(index).URL((Map<String, String>)var16_16) + path;
        } else {
            targetURL = this.basePath + path;
        }
        WebTarget target = this.httpClient.target(targetURL);
        if (queryParams != null) {
            for (Pair pair : queryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{this.escapeString(pair.getValue())});
            }
        }
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{accept});
        for (Map.Entry<String, String> entry : headerParams.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.header(entry.getKey(), (Object)value);
        }
        for (Map.Entry<String, String> entry : cookieParams.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), value);
        }
        for (Map.Entry<String, String> entry : this.defaultCookieMap.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), value);
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            String value2;
            String key = entry.getKey();
            if (headerParams.containsKey(key) || (value2 = entry.getValue()) == null) continue;
            invocationBuilder = invocationBuilder.header(key, (Object)value2);
        }
        Entity<?> entity = this.serialize(body, formParams, contentType);
        Response response = null;
        try {
            if ("GET".equals(method)) {
                response = invocationBuilder.get();
            } else if ("POST".equals(method)) {
                response = invocationBuilder.post(entity);
            } else if ("PUT".equals(method)) {
                response = invocationBuilder.put(entity);
            } else if ("DELETE".equals(method)) {
                response = invocationBuilder.method("DELETE", entity);
            } else if ("PATCH".equals(method)) {
                response = invocationBuilder.method("PATCH", entity);
            } else if ("HEAD".equals(method)) {
                response = invocationBuilder.head();
            } else if ("OPTIONS".equals(method)) {
                response = invocationBuilder.options();
            } else {
                if (!"TRACE".equals(method)) throw new ApiException(500, "unknown method type " + method);
                response = invocationBuilder.trace();
            }
            int statusCode = response.getStatusInfo().getStatusCode();
            Map<String, List<String>> responseHeaders = this.buildResponseHeaders(response);
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                return apiResponse;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (returnType == null) {
                    ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                    return apiResponse;
                }
                ApiResponse<T> apiResponse = new ApiResponse<T>(statusCode, responseHeaders, this.deserialize(response, returnType));
                return apiResponse;
            }
            String message = "error";
            String respBody = null;
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public <T> ApiResponse<T> invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        return this.invokeAPI(null, path, method, queryParams, body, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }

    protected Client buildHttpClient(boolean debugging) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (debugging) {
            clientConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(51200)));
            clientConfig.property("jersey.config.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
            Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME).setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.glassfish.jersey.client").setLevel(Level.SEVERE);
        }
        this.performAdditionalClientConfiguration(clientConfig);
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    protected void performAdditionalClientConfiguration(ClientConfig clientConfig) {
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), headers);
        }
        return responseHeaders;
    }

    protected void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }
}

