/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.jersey.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.jersey.models.CriteriaQueryFieldObject;
import io.logicdrop.openapi.jersey.models.OrderedQueryField;
import io.logicdrop.openapi.jersey.models.QueryParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Query source
 */
@ApiModel(description = "Query source")
@JsonPropertyOrder({
  QuerySource.JSON_PROPERTY_PROPERTIES,
  QuerySource.JSON_PROPERTY_PARAMETERS,
  QuerySource.JSON_PROPERTY_NAME,
  QuerySource.JSON_PROPERTY_SOURCE,
  QuerySource.JSON_PROPERTY_IGNORE_NULLS,
  QuerySource.JSON_PROPERTY_IGNORE_CASE,
  QuerySource.JSON_PROPERTY_DEBUG,
  QuerySource.JSON_PROPERTY_LIMIT,
  QuerySource.JSON_PROPERTY_EXCLUDE,
  QuerySource.JSON_PROPERTY_EXPECTS,
  QuerySource.JSON_PROPERTY_PROJECTIONS,
  QuerySource.JSON_PROPERTY_ORDERING,
  QuerySource.JSON_PROPERTY_CRITERIA
})

public class QuerySource {
  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private List<QueryParameter> parameters = null;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_IGNORE_NULLS = "ignoreNulls";
  private Boolean ignoreNulls;

  public static final String JSON_PROPERTY_IGNORE_CASE = "ignoreCase";
  private Boolean ignoreCase;

  public static final String JSON_PROPERTY_DEBUG = "debug";
  private Boolean debug;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_EXCLUDE = "exclude";
  private Boolean exclude;

  public static final String JSON_PROPERTY_EXPECTS = "expects";
  private String expects;

  public static final String JSON_PROPERTY_PROJECTIONS = "projections";
  private List<String> projections = null;

  public static final String JSON_PROPERTY_ORDERING = "ordering";
  private List<OrderedQueryField> ordering = null;

  public static final String JSON_PROPERTY_CRITERIA = "criteria";
  private List<CriteriaQueryFieldObject> criteria = null;


  public QuerySource properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public QuerySource putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public QuerySource parameters(List<QueryParameter> parameters) {
    
    this.parameters = parameters;
    return this;
  }

  public QuerySource addParametersItem(QueryParameter parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

   /**
   * Get parameters
   * @return parameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<QueryParameter> getParameters() {
    return parameters;
  }


  public void setParameters(List<QueryParameter> parameters) {
    this.parameters = parameters;
  }


  public QuerySource name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public QuerySource source(String source) {
    
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }


  public void setSource(String source) {
    this.source = source;
  }


  public QuerySource ignoreNulls(Boolean ignoreNulls) {
    
    this.ignoreNulls = ignoreNulls;
    return this;
  }

   /**
   * Get ignoreNulls
   * @return ignoreNulls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IGNORE_NULLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreNulls() {
    return ignoreNulls;
  }


  public void setIgnoreNulls(Boolean ignoreNulls) {
    this.ignoreNulls = ignoreNulls;
  }


  public QuerySource ignoreCase(Boolean ignoreCase) {
    
    this.ignoreCase = ignoreCase;
    return this;
  }

   /**
   * Get ignoreCase
   * @return ignoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreCase() {
    return ignoreCase;
  }


  public void setIgnoreCase(Boolean ignoreCase) {
    this.ignoreCase = ignoreCase;
  }


  public QuerySource debug(Boolean debug) {
    
    this.debug = debug;
    return this;
  }

   /**
   * Get debug
   * @return debug
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEBUG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDebug() {
    return debug;
  }


  public void setDebug(Boolean debug) {
    this.debug = debug;
  }


  public QuerySource limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * Get limit
   * @return limit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public QuerySource exclude(Boolean exclude) {
    
    this.exclude = exclude;
    return this;
  }

   /**
   * Get exclude
   * @return exclude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXCLUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExclude() {
    return exclude;
  }


  public void setExclude(Boolean exclude) {
    this.exclude = exclude;
  }


  public QuerySource expects(String expects) {
    
    this.expects = expects;
    return this;
  }

   /**
   * Get expects
   * @return expects
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPECTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpects() {
    return expects;
  }


  public void setExpects(String expects) {
    this.expects = expects;
  }


  public QuerySource projections(List<String> projections) {
    
    this.projections = projections;
    return this;
  }

  public QuerySource addProjectionsItem(String projectionsItem) {
    if (this.projections == null) {
      this.projections = new ArrayList<>();
    }
    this.projections.add(projectionsItem);
    return this;
  }

   /**
   * Get projections
   * @return projections
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROJECTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getProjections() {
    return projections;
  }


  public void setProjections(List<String> projections) {
    this.projections = projections;
  }


  public QuerySource ordering(List<OrderedQueryField> ordering) {
    
    this.ordering = ordering;
    return this;
  }

  public QuerySource addOrderingItem(OrderedQueryField orderingItem) {
    if (this.ordering == null) {
      this.ordering = new ArrayList<>();
    }
    this.ordering.add(orderingItem);
    return this;
  }

   /**
   * Get ordering
   * @return ordering
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORDERING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderedQueryField> getOrdering() {
    return ordering;
  }


  public void setOrdering(List<OrderedQueryField> ordering) {
    this.ordering = ordering;
  }


  public QuerySource criteria(List<CriteriaQueryFieldObject> criteria) {
    
    this.criteria = criteria;
    return this;
  }

  public QuerySource addCriteriaItem(CriteriaQueryFieldObject criteriaItem) {
    if (this.criteria == null) {
      this.criteria = new ArrayList<>();
    }
    this.criteria.add(criteriaItem);
    return this;
  }

   /**
   * Get criteria
   * @return criteria
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaQueryFieldObject> getCriteria() {
    return criteria;
  }


  public void setCriteria(List<CriteriaQueryFieldObject> criteria) {
    this.criteria = criteria;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuerySource querySource = (QuerySource) o;
    return Objects.equals(this.properties, querySource.properties) &&
        Objects.equals(this.parameters, querySource.parameters) &&
        Objects.equals(this.name, querySource.name) &&
        Objects.equals(this.source, querySource.source) &&
        Objects.equals(this.ignoreNulls, querySource.ignoreNulls) &&
        Objects.equals(this.ignoreCase, querySource.ignoreCase) &&
        Objects.equals(this.debug, querySource.debug) &&
        Objects.equals(this.limit, querySource.limit) &&
        Objects.equals(this.exclude, querySource.exclude) &&
        Objects.equals(this.expects, querySource.expects) &&
        Objects.equals(this.projections, querySource.projections) &&
        Objects.equals(this.ordering, querySource.ordering) &&
        Objects.equals(this.criteria, querySource.criteria);
  }

  @Override
  public int hashCode() {
    return Objects.hash(properties, parameters, name, source, ignoreNulls, ignoreCase, debug, limit, exclude, expects, projections, ordering, criteria);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuerySource {\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    ignoreNulls: ").append(toIndentedString(ignoreNulls)).append("\n");
    sb.append("    ignoreCase: ").append(toIndentedString(ignoreCase)).append("\n");
    sb.append("    debug: ").append(toIndentedString(debug)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    expects: ").append(toIndentedString(expects)).append("\n");
    sb.append("    projections: ").append(toIndentedString(projections)).append("\n");
    sb.append("    ordering: ").append(toIndentedString(ordering)).append("\n");
    sb.append("    criteria: ").append(toIndentedString(criteria)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

