/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.jersey.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Designer options
 */
@ApiModel(description = "Designer options")
@JsonPropertyOrder({
  DesignerOptions.JSON_PROPERTY_DEBUG,
  DesignerOptions.JSON_PROPERTY_THRESHOLD,
  DesignerOptions.JSON_PROPERTY_CONTENT,
  DesignerOptions.JSON_PROPERTY_TRACING,
  DesignerOptions.JSON_PROPERTY_EXPAND,
  DesignerOptions.JSON_PROPERTY_DICTIONARY
})

public class DesignerOptions {
  public static final String JSON_PROPERTY_DEBUG = "debug";
  private Boolean debug = true;

  public static final String JSON_PROPERTY_THRESHOLD = "threshold";
  private Integer threshold = 1000;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private Boolean content = true;

  public static final String JSON_PROPERTY_TRACING = "tracing";
  private Boolean tracing = true;

  public static final String JSON_PROPERTY_EXPAND = "expand";
  private Boolean expand = false;

  public static final String JSON_PROPERTY_DICTIONARY = "dictionary";
  private Boolean dictionary = true;


  public DesignerOptions debug(Boolean debug) {
    
    this.debug = debug;
    return this;
  }

   /**
   * Enable debugging?
   * @return debug
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Enable debugging?")
  @JsonProperty(JSON_PROPERTY_DEBUG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDebug() {
    return debug;
  }


  public void setDebug(Boolean debug) {
    this.debug = debug;
  }


  public DesignerOptions threshold(Integer threshold) {
    
    this.threshold = threshold;
    return this;
  }

   /**
   * Maximum rules to fire
   * @return threshold
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Maximum rules to fire")
  @JsonProperty(JSON_PROPERTY_THRESHOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getThreshold() {
    return threshold;
  }


  public void setThreshold(Integer threshold) {
    this.threshold = threshold;
  }


  public DesignerOptions content(Boolean content) {
    
    this.content = content;
    return this;
  }

   /**
   * Include ruleset content?
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Include ruleset content?")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getContent() {
    return content;
  }


  public void setContent(Boolean content) {
    this.content = content;
  }


  public DesignerOptions tracing(Boolean tracing) {
    
    this.tracing = tracing;
    return this;
  }

   /**
   * Enable event tracing?
   * @return tracing
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Enable event tracing?")
  @JsonProperty(JSON_PROPERTY_TRACING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTracing() {
    return tracing;
  }


  public void setTracing(Boolean tracing) {
    this.tracing = tracing;
  }


  public DesignerOptions expand(Boolean expand) {
    
    this.expand = expand;
    return this;
  }

   /**
   * Expand data in events?
   * @return expand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Expand data in events?")
  @JsonProperty(JSON_PROPERTY_EXPAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExpand() {
    return expand;
  }


  public void setExpand(Boolean expand) {
    this.expand = expand;
  }


  public DesignerOptions dictionary(Boolean dictionary) {
    
    this.dictionary = dictionary;
    return this;
  }

   /**
   * Include flattened data
   * @return dictionary
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Include flattened data")
  @JsonProperty(JSON_PROPERTY_DICTIONARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDictionary() {
    return dictionary;
  }


  public void setDictionary(Boolean dictionary) {
    this.dictionary = dictionary;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DesignerOptions designerOptions = (DesignerOptions) o;
    return Objects.equals(this.debug, designerOptions.debug) &&
        Objects.equals(this.threshold, designerOptions.threshold) &&
        Objects.equals(this.content, designerOptions.content) &&
        Objects.equals(this.tracing, designerOptions.tracing) &&
        Objects.equals(this.expand, designerOptions.expand) &&
        Objects.equals(this.dictionary, designerOptions.dictionary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(debug, threshold, content, tracing, expand, dictionary);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DesignerOptions {\n");
    sb.append("    debug: ").append(toIndentedString(debug)).append("\n");
    sb.append("    threshold: ").append(toIndentedString(threshold)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    tracing: ").append(toIndentedString(tracing)).append("\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    dictionary: ").append(toIndentedString(dictionary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

