/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.jersey.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Assertions to apply
 */
@ApiModel(description = "Assertions to apply")
@JsonPropertyOrder({
  Assertion.JSON_PROPERTY_PROPERTY,
  Assertion.JSON_PROPERTY_SHOULD,
  Assertion.JSON_PROPERTY_EXPECT,
  Assertion.JSON_PROPERTY_MESSAGE,
  Assertion.JSON_PROPERTY_STATUS,
  Assertion.JSON_PROPERTY_ENABLED
})

public class Assertion {
  public static final String JSON_PROPERTY_PROPERTY = "property";
  private String property;

  /**
   * Test to perform
   */
  public enum ShouldEnum {
    EQUAL("EQUAL"),
    
    NOT_EQUAL("NOT_EQUAL");

    private String value;

    ShouldEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShouldEnum fromValue(String value) {
      for (ShouldEnum b : ShouldEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOULD = "should";
  private ShouldEnum should;

  public static final String JSON_PROPERTY_EXPECT = "expect";
  private Object expect;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  /**
   * Status of the assertion
   */
  public enum StatusEnum {
    PASS("PASS"),
    
    FAIL("FAIL");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;


  public Assertion property(String property) {
    
    this.property = property;
    return this;
  }

   /**
   * Attribute to test
   * @return property
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Attribute to test")
  @JsonProperty(JSON_PROPERTY_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProperty() {
    return property;
  }


  public void setProperty(String property) {
    this.property = property;
  }


  public Assertion should(ShouldEnum should) {
    
    this.should = should;
    return this;
  }

   /**
   * Test to perform
   * @return should
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Test to perform")
  @JsonProperty(JSON_PROPERTY_SHOULD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShouldEnum getShould() {
    return should;
  }


  public void setShould(ShouldEnum should) {
    this.should = should;
  }


  public Assertion expect(Object expect) {
    
    this.expect = expect;
    return this;
  }

   /**
   * Expected result
   * @return expect
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Expected result")
  @JsonProperty(JSON_PROPERTY_EXPECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExpect() {
    return expect;
  }


  public void setExpect(Object expect) {
    this.expect = expect;
  }


   /**
   * Response
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Response")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }




   /**
   * Status of the assertion
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Status of the assertion")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }




  public Assertion enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Enabled?
   * @return enabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Enabled?")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Assertion assertion = (Assertion) o;
    return Objects.equals(this.property, assertion.property) &&
        Objects.equals(this.should, assertion.should) &&
        Objects.equals(this.expect, assertion.expect) &&
        Objects.equals(this.message, assertion.message) &&
        Objects.equals(this.status, assertion.status) &&
        Objects.equals(this.enabled, assertion.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(property, should, expect, message, status, enabled);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Assertion {\n");
    sb.append("    property: ").append(toIndentedString(property)).append("\n");
    sb.append("    should: ").append(toIndentedString(should)).append("\n");
    sb.append("    expect: ").append(toIndentedString(expect)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

