package io.logicdrop.openapi.jersey.api;

import io.logicdrop.openapi.jersey.ApiException;
import io.logicdrop.openapi.jersey.ApiClient;
import io.logicdrop.openapi.jersey.ApiResponse;
import io.logicdrop.openapi.jersey.Configuration;
import io.logicdrop.openapi.jersey.Pair;

import javax.ws.rs.core.GenericType;

import io.logicdrop.openapi.jersey.models.CacheRequest;
import io.logicdrop.openapi.jersey.models.CacheResult;
import io.logicdrop.openapi.jersey.models.UserData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class CacheServicesApi {
  private ApiClient apiClient;

  public CacheServicesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public CacheServicesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Evict cache entry
   * Evict cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param key Entry key (required)
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Original value </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData evictEntry(String client, String cache, String key) throws ApiException {
    return evictEntryWithHttpInfo(client, cache, key).getData();
  }

  /**
   * Evict cache entry
   * Evict cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param key Entry key (required)
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Original value </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> evictEntryWithHttpInfo(String client, String cache, String key) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling evictEntry");
    }
    
    // verify the required parameter 'cache' is set
    if (cache == null) {
      throw new ApiException(400, "Missing the required parameter 'cache' when calling evictEntry");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling evictEntry");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}/{cache}/{key}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "cache" + "\\}", apiClient.escapeString(cache.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Flush cache
   * Clear the cache
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @return CacheResult
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Flushed cache </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public CacheResult flushCache(String client, String cache) throws ApiException {
    return flushCacheWithHttpInfo(client, cache).getData();
  }

  /**
   * Flush cache
   * Clear the cache
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @return ApiResponse&lt;CacheResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Flushed cache </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<CacheResult> flushCacheWithHttpInfo(String client, String cache) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling flushCache");
    }
    
    // verify the required parameter 'cache' is set
    if (cache == null) {
      throw new ApiException(400, "Missing the required parameter 'cache' when calling flushCache");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}/{cache}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "cache" + "\\}", apiClient.escapeString(cache.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<CacheResult> localVarReturnType = new GenericType<CacheResult>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List cache entries
   * List cache entries
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Cache data </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData getEntries(String client, String cache) throws ApiException {
    return getEntriesWithHttpInfo(client, cache).getData();
  }

  /**
   * List cache entries
   * List cache entries
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Cache data </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> getEntriesWithHttpInfo(String client, String cache) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getEntries");
    }
    
    // verify the required parameter 'cache' is set
    if (cache == null) {
      throw new ApiException(400, "Missing the required parameter 'cache' when calling getEntries");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}/{cache}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "cache" + "\\}", apiClient.escapeString(cache.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get cache entry
   * Get cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param key Entry key (required)
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Cache data </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData getEntry(String client, String cache, String key) throws ApiException {
    return getEntryWithHttpInfo(client, cache, key).getData();
  }

  /**
   * Get cache entry
   * Get cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param key Entry key (required)
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Cache data </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> getEntryWithHttpInfo(String client, String cache, String key) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling getEntry");
    }
    
    // verify the required parameter 'cache' is set
    if (cache == null) {
      throw new ApiException(400, "Missing the required parameter 'cache' when calling getEntry");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getEntry");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}/{cache}/{key}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "cache" + "\\}", apiClient.escapeString(cache.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * List caches
   * Get caches using optional simple filters
   * @param client Client name (required)
   * @param local Include near or local caches (optional)
   * @return List&lt;CacheResult&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved cache names </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public List<CacheResult> listCaches(String client, String local) throws ApiException {
    return listCachesWithHttpInfo(client, local).getData();
  }

  /**
   * List caches
   * Get caches using optional simple filters
   * @param client Client name (required)
   * @param local Include near or local caches (optional)
   * @return ApiResponse&lt;List&lt;CacheResult&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Retrieved cache names </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<CacheResult>> listCachesWithHttpInfo(String client, String local) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling listCaches");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "local", local));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<List<CacheResult>> localVarReturnType = new GenericType<List<CacheResult>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Put cache entry
   * Put cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param cacheRequest Cache Entry (required)
   * @return UserData
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Original value </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public UserData putEntry(String client, String cache, CacheRequest cacheRequest) throws ApiException {
    return putEntryWithHttpInfo(client, cache, cacheRequest).getData();
  }

  /**
   * Put cache entry
   * Put cache entry
   * @param client Client name (required)
   * @param cache Cache name (required)
   * @param cacheRequest Cache Entry (required)
   * @return ApiResponse&lt;UserData&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> Original value </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
       <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
       <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
       <tr><td> 500 </td><td> Backend Error </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<UserData> putEntryWithHttpInfo(String client, String cache, CacheRequest cacheRequest) throws ApiException {
    Object localVarPostBody = cacheRequest;
    
    // verify the required parameter 'client' is set
    if (client == null) {
      throw new ApiException(400, "Missing the required parameter 'client' when calling putEntry");
    }
    
    // verify the required parameter 'cache' is set
    if (cache == null) {
      throw new ApiException(400, "Missing the required parameter 'cache' when calling putEntry");
    }
    
    // verify the required parameter 'cacheRequest' is set
    if (cacheRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheRequest' when calling putEntry");
    }
    
    // create path and map variables
    String localVarPath = "/caches/{client}/{cache}"
      .replaceAll("\\{" + "client" + "\\}", apiClient.escapeString(client.toString()))
      .replaceAll("\\{" + "cache" + "\\}", apiClient.escapeString(cache.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

    GenericType<UserData> localVarReturnType = new GenericType<UserData>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
