/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.logicdrop.openapi.java.api;

import io.logicdrop.openapi.java.ApiClient;
import io.logicdrop.openapi.java.ApiException;
import io.logicdrop.openapi.java.Pair;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.QueryRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UserQuery;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;



public class QueryServicesApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  
  public QueryServicesApi() {
    this(new ApiClient());
  }

  public QueryServicesApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
  }

  /**
   * Delete queries
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove queries by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deleteQueries (String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteQueries");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteQueries");
    }
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteQueries");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(deleteArtifactRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteQueries call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete query
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Query name (required)
   * @param v Query version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deleteQuery (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteQuery");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteQuery");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Execute live query
   * Execute a live query
   * @param client Client name (required)
   * @param queryRequest Query to execute (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object executeQuery (String client, QueryRequest queryRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling executeQuery");
    }
    // verify the required parameter 'queryRequest' is set
    if (queryRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'queryRequest' when calling executeQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/execute"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(queryRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "executeQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Object>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get query
   * Get a query
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Query name (required)
   * @param v Query version (optional)
   * @param view Fields to return in the results (optional
   * @return UserQuery
   * @throws ApiException if fails to make API call
   */
  public UserQuery getQuery (String client, String project, String artifact, String v, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getQuery");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getQuery");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UserQuery>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List queries
   * Get queries using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional
   * @return List&lt;UserQuery&gt;
   * @throws ApiException if fails to make API call
   */
  public List<UserQuery> listQueries (String client, String project, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listQueries");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling listQueries");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listQueries call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<UserQuery>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Execute saved query
   * Execute a saved query
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Query name (required)
   * @param v Query version (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object runQuery (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling runQuery");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling runQuery");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling runQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}/{artifact}/run"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "runQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Object>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Save query
   * Saves or creates a query (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param userQuery Query to persist (required)
   * @return UserQuery
   * @throws ApiException if fails to make API call
   */
  public UserQuery saveQuery (String client, String project, UserQuery userQuery) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling saveQuery");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling saveQuery");
    }
    // verify the required parameter 'userQuery' is set
    if (userQuery == null) {
        throw new ApiException(400, "Missing the required parameter 'userQuery' when calling saveQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(userQuery);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "saveQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UserQuery>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update queries
   * Updates multiple queries
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Queries to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updateQueries (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateQueries");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateQueries");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateQueries");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateQueries call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update query
   * Updates one query
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Query to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updateQuery (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateQuery");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateQuery");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateQuery");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/query/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateQuery call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
}
