/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.logicdrop.openapi.java.api;

import io.logicdrop.openapi.java.ApiClient;
import io.logicdrop.openapi.java.ApiException;
import io.logicdrop.openapi.java.Pair;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.BuildPipelineRequest;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.Pipeline;
import io.logicdrop.openapi.models.PipelineBuilderResult;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdatePipelineResponse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;



public class PipelineServicesApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  
  public PipelineServicesApi() {
    this(new ApiClient());
  }

  public PipelineServicesApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
  }

  /**
   * Build pipeline
   * Build pipeline
   * @param client Client name (required)
   * @param buildPipelineRequest  (optional)
   * @return PipelineBuilderResult
   * @throws ApiException if fails to make API call
   */
  public PipelineBuilderResult buildPipeline (String client, BuildPipelineRequest buildPipelineRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling buildPipeline");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/build"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(buildPipelineRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "buildPipeline call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PipelineBuilderResult>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete pipeline
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Pipeline name (required)
   * @param v Pipeline version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deletePipeline (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deletePipeline");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deletePipeline");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deletePipeline");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deletePipeline call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete pipelines
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove pipelines by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deletePipelines (String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deletePipelines");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deletePipelines");
    }
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deletePipelines");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(deleteArtifactRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deletePipelines call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get pipeline
   * Get an pipeline
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Pipeline name (required)
   * @param v Pipeline version (optional)
   * @param view Fields to return in the results (optional
   * @return Pipeline
   * @throws ApiException if fails to make API call
   */
  public Pipeline getPipeline (String client, String project, String artifact, String v, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getPipeline");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getPipeline");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getPipeline");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getPipeline call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Pipeline>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get content
   * Get pipeline content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Pipeline name (required)
   * @param v Pipeline version (optional)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String getPipelineContent (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getPipelineContent");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getPipelineContent");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getPipelineContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}/{artifact}/content"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getPipelineContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List pipelines
   * Get pipelines using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional
   * @return List&lt;Pipeline&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Pipeline> listPipelines (String client, String project, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listPipelines");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling listPipelines");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listPipelines call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<Pipeline>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Save pipeline
   * Saves or creates a pipeline (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param pipeline Pipeline to persist (required)
   * @return Pipeline
   * @throws ApiException if fails to make API call
   */
  public Pipeline savePipeline (String client, String project, Pipeline pipeline) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling savePipeline");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling savePipeline");
    }
    // verify the required parameter 'pipeline' is set
    if (pipeline == null) {
        throw new ApiException(400, "Missing the required parameter 'pipeline' when calling savePipeline");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(pipeline);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "savePipeline call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Pipeline>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update pipeline
   * Updates one pipeline
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Pipelines to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updatePipeline (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updatePipeline");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updatePipeline");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updatePipeline");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updatePipeline call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update content
   * Update the pipeline
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Pipeline name (required)
   * @param v Pipeline version (optional)
   * @param body  (optional)
   * @return UpdatePipelineResponse
   * @throws ApiException if fails to make API call
   */
  public UpdatePipelineResponse updatePipelineContent (String client, String project, String artifact, String v, String body) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updatePipelineContent");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updatePipelineContent");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling updatePipelineContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}/{artifact}/content"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updatePipelineContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UpdatePipelineResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update pipelines
   * Updates multiple pipelines
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Pipelines to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updatePipelines (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updatePipelines");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updatePipelines");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updatePipelines");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/pipelines/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updatePipelines call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
}
