/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.logicdrop.openapi.java.api;

import io.logicdrop.openapi.java.ApiClient;
import io.logicdrop.openapi.java.ApiException;
import io.logicdrop.openapi.java.Pair;

import java.io.File;
import io.logicdrop.openapi.models.FileResult;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;



public class ContentServicesApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  
  public ContentServicesApi() {
    this(new ApiClient());
  }

  public ContentServicesApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
  }

  /**
   * Delete content
   * Delete a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> deleteContent (String client, String folders, String filename, String extension) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling deleteContent");
    }
    // verify the required parameter 'filename' is set
    if (filename == null) {
        throw new ApiException(400, "Missing the required parameter 'filename' when calling deleteContent");
    }
    // verify the required parameter 'extension' is set
    if (extension == null) {
        throw new ApiException(400, "Missing the required parameter 'extension' when calling deleteContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/{folders}/{filename}.{extension}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()))
        .replace("{filename}", ApiClient.urlEncode(filename.toString()))
        .replace("{extension}", ApiClient.urlEncode(extension.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete private content
   * Delete a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> deletePrivateContent (String client, String folders, String filename, String extension) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deletePrivateContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling deletePrivateContent");
    }
    // verify the required parameter 'filename' is set
    if (filename == null) {
        throw new ApiException(400, "Missing the required parameter 'filename' when calling deletePrivateContent");
    }
    // verify the required parameter 'extension' is set
    if (extension == null) {
        throw new ApiException(400, "Missing the required parameter 'extension' when calling deletePrivateContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()))
        .replace("{filename}", ApiClient.urlEncode(filename.toString()))
        .replace("{extension}", ApiClient.urlEncode(extension.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deletePrivateContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get content
   * Get a file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @throws ApiException if fails to make API call
   */
  public void getContent (String client, String folders, String filename, String extension) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling getContent");
    }
    // verify the required parameter 'filename' is set
    if (filename == null) {
        throw new ApiException(400, "Missing the required parameter 'filename' when calling getContent");
    }
    // verify the required parameter 'extension' is set
    if (extension == null) {
        throw new ApiException(400, "Missing the required parameter 'extension' when calling getContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/{folders}/{filename}.{extension}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()))
        .replace("{filename}", ApiClient.urlEncode(filename.toString()))
        .replace("{extension}", ApiClient.urlEncode(extension.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get private content
   * Get a private file in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @throws ApiException if fails to make API call
   */
  public void getPrivateContent (String client, String folders, String filename, String extension) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getPrivateContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling getPrivateContent");
    }
    // verify the required parameter 'filename' is set
    if (filename == null) {
        throw new ApiException(400, "Missing the required parameter 'filename' when calling getPrivateContent");
    }
    // verify the required parameter 'extension' is set
    if (extension == null) {
        throw new ApiException(400, "Missing the required parameter 'extension' when calling getPrivateContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/private/{folders}/{filename}.{extension}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()))
        .replace("{filename}", ApiClient.urlEncode(filename.toString()))
        .replace("{extension}", ApiClient.urlEncode(extension.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getPrivateContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get signed token
   * Get a signed token for uploading or downloading directly
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param filename Filename (required)
   * @param extension Extension (required)
   * @param expires Expiration (optional)
   * @param _public Private or public origin (default false) (optional)
   * @param upload URL for uploading (optional)
   * @return FileResult
   * @throws ApiException if fails to make API call
   */
  public FileResult getSignedToken (String client, String folders, String filename, String extension, String expires, String _public, String upload) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getSignedToken");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling getSignedToken");
    }
    // verify the required parameter 'filename' is set
    if (filename == null) {
        throw new ApiException(400, "Missing the required parameter 'filename' when calling getSignedToken");
    }
    // verify the required parameter 'extension' is set
    if (extension == null) {
        throw new ApiException(400, "Missing the required parameter 'extension' when calling getSignedToken");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/signed/{folders}/{filename}.{extension}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()))
        .replace("{filename}", ApiClient.urlEncode(filename.toString()))
        .replace("{extension}", ApiClient.urlEncode(extension.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("expires", expires));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("public", _public));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("upload", upload));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getSignedToken call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<FileResult>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List contents
   * List files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> listContent (String client, String folders) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling listContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/{folders}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List private contents
   * List private files in content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param recursive Include subfolders (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> listPrivateContent (String client, String folders, String recursive) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listPrivateContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling listPrivateContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/private/{folders}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("recursive", recursive));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listPrivateContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Upload content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> uploadContent (String client, String folders, String explode, String unique, File file) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling uploadContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/{folders}/upload"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("explode", explode));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("unique", unique));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "uploadContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Upload private content
   * Upload file(s) to content
   * @param client Client name (required)
   * @param folders Folders (required)
   * @param explode If a zip or folder, explode (optional)
   * @param unique Use unique names (optional)
   * @param file File (optional)
   * @return List&lt;FileResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileResult> uploadPrivateContent (String client, String folders, String explode, String unique, File file) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling uploadPrivateContent");
    }
    // verify the required parameter 'folders' is set
    if (folders == null) {
        throw new ApiException(400, "Missing the required parameter 'folders' when calling uploadPrivateContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/content/{client}/private/{folders}/upload"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{folders}", ApiClient.urlEncode(folders.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("explode", explode));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("unique", unique));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "uploadPrivateContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<FileResult>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
}
