/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.logicdrop.openapi.java.api;

import io.logicdrop.openapi.java.ApiClient;
import io.logicdrop.openapi.java.ApiException;
import io.logicdrop.openapi.java.Pair;

import io.logicdrop.openapi.models.ActivateRulesetResponse;
import io.logicdrop.openapi.models.AnalyzerRequest;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.ComputePipelineRequest;
import io.logicdrop.openapi.models.ComputePipelineResponse;
import io.logicdrop.openapi.models.ComputeRule;
import io.logicdrop.openapi.models.ComputeRuleset;
import io.logicdrop.openapi.models.ContainerResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.DesignerResult;
import java.io.File;
import io.logicdrop.openapi.models.GenerateAllRequest;
import io.logicdrop.openapi.models.GenerateOneRequest;
import io.logicdrop.openapi.models.ProcessorRequest;
import io.logicdrop.openapi.models.ProcessorResult;
import io.logicdrop.openapi.models.RuleContainer;
import io.logicdrop.openapi.models.SamplerRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateRuleTypesRequest;
import io.logicdrop.openapi.models.UpdateRulesetResponse;
import io.logicdrop.openapi.models.UploadResponse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;



public class ComputeServicesApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  
  public ComputeServicesApi() {
    this(new ApiClient());
  }

  public ComputeServicesApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
  }

  /**
   * Activate ruleset
   * Activate a ruleset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return ActivateRulesetResponse
   * @throws ApiException if fails to make API call
   */
  public ActivateRulesetResponse activateRuleset (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling activateRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling activateRuleset");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling activateRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/activate"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "activateRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ActivateRulesetResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Analyze ruleset
   * Analyze ruleset
   * @param client Client (required)
   * @param analyzerRequest Analysis execute request (required)
   * @return DesignerResult
   * @throws ApiException if fails to make API call
   */
  public DesignerResult analyzeRuleset (String client, AnalyzerRequest analyzerRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling analyzeRuleset");
    }
    // verify the required parameter 'analyzerRequest' is set
    if (analyzerRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'analyzerRequest' when calling analyzeRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/analyze"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(analyzerRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "analyzeRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DesignerResult>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Deactivate ruleset
   * Deactivate a ruleset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return ActivateRulesetResponse
   * @throws ApiException if fails to make API call
   */
  public ActivateRulesetResponse deactivateRuleset (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deactivateRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deactivateRuleset");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deactivateRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/activate"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deactivateRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ActivateRulesetResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete rule
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param id Rule Id (required)
   * @param v Ruleset version (optional)
   * @return DataResponse
   * @throws ApiException if fails to make API call
   */
  public DataResponse deleteRule (String client, String project, String artifact, String id, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRule");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRule");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRule");
    }
    // verify the required parameter 'id' is set
    if (id == null) {
        throw new ApiException(400, "Missing the required parameter 'id' when calling deleteRule");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules/{id}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()))
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteRule call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DataResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete rules
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param deleteDataRequest Remove rules by criteria (required)
   * @param v Ruleset version (optional)
   * @return DataResponse
   * @throws ApiException if fails to make API call
   */
  public DataResponse deleteRules (String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRules");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRules");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRules");
    }
    // verify the required parameter 'deleteDataRequest' is set
    if (deleteDataRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'deleteDataRequest' when calling deleteRules");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(deleteDataRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteRules call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DataResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete ruleset
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deleteRuleset (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRuleset");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling deleteRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Delete rulesets
   * 
   * @param client Client name (required)
   * @param project Project name (required)
   * @param deleteArtifactRequest Remove ruleset by criteria (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse deleteRulesets (String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling deleteRulesets");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling deleteRulesets");
    }
    // verify the required parameter 'deleteArtifactRequest' is set
    if (deleteArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'deleteArtifactRequest' when calling deleteRulesets");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(deleteArtifactRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "deleteRulesets call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Execute pipeline
   * Executes a pipeline
   * @param client Client name (required)
   * @param xLogicdropRoute Route (required)
   * @param xLogicdropPath Path (required)
   * @param computePipelineRequest Pipeline request (required)
   * @return ComputePipelineResponse
   * @throws ApiException if fails to make API call
   */
  public ComputePipelineResponse executeCompute (String client, String xLogicdropRoute, String xLogicdropPath, ComputePipelineRequest computePipelineRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling executeCompute");
    }
    // verify the required parameter 'xLogicdropRoute' is set
    if (xLogicdropRoute == null) {
        throw new ApiException(400, "Missing the required parameter 'xLogicdropRoute' when calling executeCompute");
    }
    // verify the required parameter 'xLogicdropPath' is set
    if (xLogicdropPath == null) {
        throw new ApiException(400, "Missing the required parameter 'xLogicdropPath' when calling executeCompute");
    }
    // verify the required parameter 'computePipelineRequest' is set
    if (computePipelineRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'computePipelineRequest' when calling executeCompute");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/pipeline"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    if (xLogicdropRoute != null) {
      localVarRequestBuilder.header("X-Logicdrop-Route", xLogicdropRoute.toString());
    }
    if (xLogicdropPath != null) {
      localVarRequestBuilder.header("X-Logicdrop-Path", xLogicdropPath.toString());
    }
    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(computePipelineRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "executeCompute call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputePipelineResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Execute ruleset
   * Process rules using a simple input/output request
   * @param client Client (required)
   * @param processorRequest Processor Request (required)
   * @return ProcessorResult
   * @throws ApiException if fails to make API call
   */
  public ProcessorResult executeRuleset (String client, ProcessorRequest processorRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling executeRuleset");
    }
    // verify the required parameter 'processorRequest' is set
    if (processorRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'processorRequest' when calling executeRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/execute"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(processorRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "executeRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ProcessorResult>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Execute sample
   * Sample ruleset using a simple input/output request
   * @param client Client (required)
   * @param samplerRequest Sampling Request (required)
   * @return DesignerResult
   * @throws ApiException if fails to make API call
   */
  public DesignerResult executeSample (String client, SamplerRequest samplerRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling executeSample");
    }
    // verify the required parameter 'samplerRequest' is set
    if (samplerRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'samplerRequest' when calling executeSample");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/sample"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(samplerRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "executeSample call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DesignerResult>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Generate ruleset
   * Generate ruleset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param type Compiler Type (optional, default to &quot;drl&quot;)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String generateRuleset (String client, String project, String artifact, String v, String type) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling generateRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling generateRuleset");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling generateRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/generate"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("type", type));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "generateRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get rule
   * Get a rule
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param id Rule Id (required)
   * @param v Ruleset version (optional)
   * @param view Fields to return in the results (optional
   * @return ComputeRule
   * @throws ApiException if fails to make API call
   */
  public ComputeRule getRule (String client, String project, String artifact, String id, String v, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getRule");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getRule");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRule");
    }
    // verify the required parameter 'id' is set
    if (id == null) {
        throw new ApiException(400, "Missing the required parameter 'id' when calling getRule");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules/{id}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()))
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getRule call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputeRule>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get ruleset
   * Get an ruleset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param view Fields to return in the results (optional
   * @return ComputeRuleset
   * @throws ApiException if fails to make API call
   */
  public ComputeRuleset getRuleset (String client, String project, String artifact, String v, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getRuleset");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputeRuleset>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get content
   * Get ruleset content
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String getRulesetContent (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetContent");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetContent");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetContent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/content"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getRulesetContent call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get example request
   * Get ruleset request example
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String getRulesetExample (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetExample");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetExample");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetExample");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/example"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getRulesetExample call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Get types
   * Get ruleset types
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String getRulesetTypes (String client, String project, String artifact, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling getRulesetTypes");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling getRulesetTypes");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling getRulesetTypes");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/types"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "getRulesetTypes call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List containers
   * Get containers possibly filtered by project and/or ruleset
   * @param client Client name (required)
   * @param project Filter by project containers (optional)
   * @param ruleset Filter by ruleset containers (optional)
   * @param status Container status (optional)
   * @return ContainerResponse
   * @throws ApiException if fails to make API call
   */
  public ContainerResponse listContainers (String client, String project, String ruleset, String status) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listContainers");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/containers"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("project", project));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("ruleset", ruleset));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("status", status));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listContainers call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ContainerResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List rules
   * Get rules using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param criteria Criteria (optional)
   * @param type Rule types (optional, default to user)
   * @param fields Any fields that match the single value only (requires a value) (optional
   * @param value Value to find in any fields (requires fields) (optional)
   * @param view Fields to return in the results (optional
   * @param filter Filters to apply (optional
   * @param order Fields to order by (optional
   * @param tags Tags to filter by (optional
   * @param ignoreCase Ignore case (optional, default to false)
   * @return List&lt;ComputeRule&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ComputeRule> listRules (String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listRules");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling listRules");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRules");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("criteria", criteria));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("type", type));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "fields", fields));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("value", value));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "filter", filter));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "order", order));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "tags", tags));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("ignoreCase", ignoreCase));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listRules call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<ComputeRule>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List rules by key
   * Get rules using a single key/value
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param key Field name (required)
   * @param value Field value (required)
   * @param v Ruleset version (optional)
   * @param view Fields to return in the results (optional
   * @return List&lt;ComputeRule&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ComputeRule> listRulesBy (String client, String project, String artifact, String key, String value, String v, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listRulesBy");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling listRulesBy");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling listRulesBy");
    }
    // verify the required parameter 'key' is set
    if (key == null) {
        throw new ApiException(400, "Missing the required parameter 'key' when calling listRulesBy");
    }
    // verify the required parameter 'value' is set
    if (value == null) {
        throw new ApiException(400, "Missing the required parameter 'value' when calling listRulesBy");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules/by/{key}/{value}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()))
        .replace("{key}", ApiClient.urlEncode(key.toString()))
        .replace("{value}", ApiClient.urlEncode(value.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listRulesBy call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<ComputeRule>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * List rulesets
   * Get rulesets using optional simple filters
   * @param client Client name (required)
   * @param project Project name (required)
   * @param view Fields to return in the results (optional
   * @return List&lt;ComputeRuleset&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ComputeRuleset> listRulesets (String client, String project, List<String> view) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling listRulesets");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling listRulesets");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("csv", "view", view));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "listRulesets call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<ComputeRuleset>>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Manage containers
   * Start/Update/Stop/Remove/Rebuild containers
   * @param client Client (required)
   * @param action Action to perform (required)
   * @param ruleContainer Container (required)
   * @return RuleContainer
   * @throws ApiException if fails to make API call
   */
  public RuleContainer manageContainer (String client, String action, RuleContainer ruleContainer) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling manageContainer");
    }
    // verify the required parameter 'action' is set
    if (action == null) {
        throw new ApiException(400, "Missing the required parameter 'action' when calling manageContainer");
    }
    // verify the required parameter 'ruleContainer' is set
    if (ruleContainer == null) {
        throw new ApiException(400, "Missing the required parameter 'ruleContainer' when calling manageContainer");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/containers"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("action", action));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(ruleContainer);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "manageContainer call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<RuleContainer>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Save rule
   * Saves or create a rule (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param computeRule Rule to persist (required)
   * @param v Ruleset version (optional)
   * @return ComputeRule
   * @throws ApiException if fails to make API call
   */
  public ComputeRule saveRule (String client, String project, String artifact, ComputeRule computeRule, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling saveRule");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling saveRule");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling saveRule");
    }
    // verify the required parameter 'computeRule' is set
    if (computeRule == null) {
        throw new ApiException(400, "Missing the required parameter 'computeRule' when calling saveRule");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/rules"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(computeRule);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "saveRule call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputeRule>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Save ruleset
   * Saves or creates an ruleset (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param computeRuleset Ruleset to persist (required)
   * @return ComputeRuleset
   * @throws ApiException if fails to make API call
   */
  public ComputeRuleset saveRuleset (String client, String project, ComputeRuleset computeRuleset) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling saveRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling saveRuleset");
    }
    // verify the required parameter 'computeRuleset' is set
    if (computeRuleset == null) {
        throw new ApiException(400, "Missing the required parameter 'computeRuleset' when calling saveRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(computeRuleset);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "saveRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputeRuleset>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update ruleset
   * Updates one ruleset
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest ruleset to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updateRuleset (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRuleset");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRuleset");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update content using file
   * Update the ruleset with custom rules using a file
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param file File (optional)
   * @return UpdateRulesetResponse
   * @throws ApiException if fails to make API call
   */
  public UpdateRulesetResponse updateRulesetContentFile (String client, String project, String artifact, String v, File file) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetContentFile");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetContentFile");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetContentFile");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/content"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRulesetContentFile call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UpdateRulesetResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update content using string
   * Update the ruleset with custom rules using a string
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param body  (optional)
   * @return UpdateRulesetResponse
   * @throws ApiException if fails to make API call
   */
  public UpdateRulesetResponse updateRulesetContentText (String client, String project, String artifact, String v, String body) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetContentText");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetContentText");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetContentText");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/content"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRulesetContentText call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UpdateRulesetResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update example request
   * Update the ruleset with an example request
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param body  (optional)
   * @return UpdateRulesetResponse
   * @throws ApiException if fails to make API call
   */
  public UpdateRulesetResponse updateRulesetExample (String client, String project, String artifact, String v, String body) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetExample");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetExample");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetExample");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/example"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRulesetExample call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UpdateRulesetResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update ruleset types
   * Saves or creates an ruleset types (overwrite)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param updateRuleTypesRequest Rule types to persist (required)
   * @param v Ruleset version (optional)
   * @return ComputeRuleset
   * @throws ApiException if fails to make API call
   */
  public ComputeRuleset updateRulesetTypes (String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesetTypes");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesetTypes");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling updateRulesetTypes");
    }
    // verify the required parameter 'updateRuleTypesRequest' is set
    if (updateRuleTypesRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateRuleTypesRequest' when calling updateRulesetTypes");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/types"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateRuleTypesRequest);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRulesetTypes call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ComputeRuleset>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Update rulesets
   * Updates multiple rules
   * @param client Client name (required)
   * @param project Project name (required)
   * @param updateArtifactRequest Rules to update (required)
   * @return ArtifactResponse
   * @throws ApiException if fails to make API call
   */
  public ArtifactResponse updateRulesets (String client, String project, UpdateArtifactRequest updateArtifactRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling updateRulesets");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling updateRulesets");
    }
    // verify the required parameter 'updateArtifactRequest' is set
    if (updateArtifactRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'updateArtifactRequest' when calling updateRulesets");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateArtifactRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "updateRulesets call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ArtifactResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Upload dataset
   * Upload rule data (Excel workbook and CSVs)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param file File (optional)
   * @return UploadResponse
   * @throws ApiException if fails to make API call
   */
  public UploadResponse uploadDatasets (String client, String project, File file) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling uploadDatasets");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling uploadDatasets");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/upload"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "uploadDatasets call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UploadResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * Upload workbook
   * Upload a decision table (Excel workbook)
   * @param client Client name (required)
   * @param project Project name (required)
   * @param artifact Ruleset name (required)
   * @param v Ruleset version (optional)
   * @param merge Merge or replace rules (optional, default to false)
   * @param file File (optional)
   * @return UploadResponse
   * @throws ApiException if fails to make API call
   */
  public UploadResponse uploadWorkbook (String client, String project, String artifact, String v, Boolean merge, File file) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling uploadWorkbook");
    }
    // verify the required parameter 'project' is set
    if (project == null) {
        throw new ApiException(400, "Missing the required parameter 'project' when calling uploadWorkbook");
    }
    // verify the required parameter 'artifact' is set
    if (artifact == null) {
        throw new ApiException(400, "Missing the required parameter 'artifact' when calling uploadWorkbook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/{project}/{artifact}/upload"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{project}", ApiClient.urlEncode(project.toString()))
        .replace("{artifact}", ApiClient.urlEncode(artifact.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    localVarQueryParams.addAll(ApiClient.parameterToPairs("v", v));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("merge", merge));

    if (!localVarQueryParams.isEmpty()) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    try {
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "uploadWorkbook call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UploadResponse>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * View ruleset source
   * Generate ruleset source for analysis
   * @param client Client (required)
   * @param generateAllRequest Analysis source request (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String viewRuleset (String client, GenerateAllRequest generateAllRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling viewRuleset");
    }
    // verify the required parameter 'generateAllRequest' is set
    if (generateAllRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'generateAllRequest' when calling viewRuleset");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/analyze/source"
        .replace("{client}", ApiClient.urlEncode(client.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(generateAllRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "viewRuleset call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
  /**
   * View single source
   * Generate a single ruleset source for analysis
   * @param client Client (required)
   * @param typeOrId ID or type (required)
   * @param generateOneRequest Analysis source request (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String viewSource (String client, String typeOrId, GenerateOneRequest generateOneRequest) throws ApiException {
    // verify the required parameter 'client' is set
    if (client == null) {
        throw new ApiException(400, "Missing the required parameter 'client' when calling viewSource");
    }
    // verify the required parameter 'typeOrId' is set
    if (typeOrId == null) {
        throw new ApiException(400, "Missing the required parameter 'typeOrId' when calling viewSource");
    }
    // verify the required parameter 'generateOneRequest' is set
    if (generateOneRequest == null) {
        throw new ApiException(400, "Missing the required parameter 'generateOneRequest' when calling viewSource");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/compute/{client}/analyze/source/{typeOrId}"
        .replace("{client}", ApiClient.urlEncode(client.toString()))
        .replace("{typeOrId}", ApiClient.urlEncode(typeOrId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(generateOneRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
      if (memberVarReadTimeout != null) {
        localVarRequestBuilder.timeout(memberVarReadTimeout);
      }
      if (memberVarInterceptor != null) {
        memberVarInterceptor.accept(localVarRequestBuilder);
      }
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
      localVarRequestBuilder.build(),
      HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }          
      if (localVarResponse.statusCode()/ 100 != 2) {
          throw new ApiException(localVarResponse.statusCode(),
              "viewSource call received non-success response",
              localVarResponse.headers(),
              localVarResponse.body() == null ? null : new String(localVarResponse.body().readAllBytes()));
      }
      return memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<String>() {});
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }
}
