/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * UpdateRulesetResponse
 */
@JsonPropertyOrder({
  UpdateRulesetResponse.JSON_PROPERTY_PROJECT,
  UpdateRulesetResponse.JSON_PROPERTY_ARTIFACT,
  UpdateRulesetResponse.JSON_PROPERTY_RECORDS,
  UpdateRulesetResponse.JSON_PROPERTY_FILENAMES
})

public class UpdateRulesetResponse {
  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_ARTIFACT = "artifact";
  private String artifact;

  public static final String JSON_PROPERTY_RECORDS = "records";
  private Long records;

  public static final String JSON_PROPERTY_FILENAMES = "filenames";
  private List<String> filenames = null;


   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }




   /**
   * Ruleset name
   * @return artifact
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset name")
  @JsonProperty(JSON_PROPERTY_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArtifact() {
    return artifact;
  }




   /**
   * Records affected
   * @return records
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Records affected")
  @JsonProperty(JSON_PROPERTY_RECORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRecords() {
    return records;
  }




   /**
   * Uploaded files
   * @return filenames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Uploaded files")
  @JsonProperty(JSON_PROPERTY_FILENAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFilenames() {
    return filenames;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateRulesetResponse updateRulesetResponse = (UpdateRulesetResponse) o;
    return Objects.equals(this.project, updateRulesetResponse.project) &&
        Objects.equals(this.artifact, updateRulesetResponse.artifact) &&
        Objects.equals(this.records, updateRulesetResponse.records) &&
        Objects.equals(this.filenames, updateRulesetResponse.filenames);
  }

  @Override
  public int hashCode() {
    return Objects.hash(project, artifact, records, filenames);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateRulesetResponse {\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    artifact: ").append(toIndentedString(artifact)).append("\n");
    sb.append("    records: ").append(toIndentedString(records)).append("\n");
    sb.append("    filenames: ").append(toIndentedString(filenames)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

