/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.java.models.SubscriptionDiscount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Subscription
 */
@JsonPropertyOrder({
  Subscription.JSON_PROPERTY_PAYMENT_ID,
  Subscription.JSON_PROPERTY_PRODUCT_ID,
  Subscription.JSON_PROPERTY_TERM,
  Subscription.JSON_PROPERTY_PRODUCT_NAME,
  Subscription.JSON_PROPERTY_PRODUCT_TIER,
  Subscription.JSON_PROPERTY_AUTO_PAY,
  Subscription.JSON_PROPERTY_PAYMENT_AMOUNT,
  Subscription.JSON_PROPERTY_PAYMENT_TERM,
  Subscription.JSON_PROPERTY_PAYMENT_CURRENCY,
  Subscription.JSON_PROPERTY_ID,
  Subscription.JSON_PROPERTY_CC_LAST4,
  Subscription.JSON_PROPERTY_CC_EXPIRATION,
  Subscription.JSON_PROPERTY_COMPANY,
  Subscription.JSON_PROPERTY_NAME,
  Subscription.JSON_PROPERTY_ADDRESS1,
  Subscription.JSON_PROPERTY_ADDRESS2,
  Subscription.JSON_PROPERTY_CITY,
  Subscription.JSON_PROPERTY_STATE,
  Subscription.JSON_PROPERTY_POSTAL_CODE,
  Subscription.JSON_PROPERTY_COUNTRY,
  Subscription.JSON_PROPERTY_CONTACT_PHONE,
  Subscription.JSON_PROPERTY_CONTACT_EMAIL,
  Subscription.JSON_PROPERTY_MODULES,
  Subscription.JSON_PROPERTY_LIMITS,
  Subscription.JSON_PROPERTY_DISCOUNTS
})

public class Subscription {
  public static final String JSON_PROPERTY_PAYMENT_ID = "paymentId";
  private String paymentId;

  public static final String JSON_PROPERTY_PRODUCT_ID = "productId";
  private String productId;

  public static final String JSON_PROPERTY_TERM = "term";
  private OffsetDateTime term;

  public static final String JSON_PROPERTY_PRODUCT_NAME = "productName";
  private String productName;

  public static final String JSON_PROPERTY_PRODUCT_TIER = "productTier";
  private String productTier;

  public static final String JSON_PROPERTY_AUTO_PAY = "autoPay";
  private Boolean autoPay;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
  private Double paymentAmount;

  public static final String JSON_PROPERTY_PAYMENT_TERM = "paymentTerm";
  private String paymentTerm;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private String paymentCurrency;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CC_LAST4 = "ccLast4";
  private String ccLast4;

  public static final String JSON_PROPERTY_CC_EXPIRATION = "ccExpiration";
  private String ccExpiration;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private String company;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_CONTACT_PHONE = "contactPhone";
  private String contactPhone;

  public static final String JSON_PROPERTY_CONTACT_EMAIL = "contactEmail";
  private String contactEmail;

  public static final String JSON_PROPERTY_MODULES = "modules";
  private List<String> modules = null;

  public static final String JSON_PROPERTY_LIMITS = "limits";
  private Map<String, Integer> limits = null;

  public static final String JSON_PROPERTY_DISCOUNTS = "discounts";
  private List<SubscriptionDiscount> discounts = null;


  public Subscription paymentId(String paymentId) {
    
    this.paymentId = paymentId;
    return this;
  }

   /**
   * Get paymentId
   * @return paymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentId() {
    return paymentId;
  }


  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }


  public Subscription productId(String productId) {
    
    this.productId = productId;
    return this;
  }

   /**
   * Get productId
   * @return productId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRODUCT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductId() {
    return productId;
  }


  public void setProductId(String productId) {
    this.productId = productId;
  }


  public Subscription term(OffsetDateTime term) {
    
    this.term = term;
    return this;
  }

   /**
   * Get term
   * @return term
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getTerm() {
    return term;
  }


  public void setTerm(OffsetDateTime term) {
    this.term = term;
  }


  public Subscription productName(String productName) {
    
    this.productName = productName;
    return this;
  }

   /**
   * Get productName
   * @return productName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRODUCT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductName() {
    return productName;
  }


  public void setProductName(String productName) {
    this.productName = productName;
  }


  public Subscription productTier(String productTier) {
    
    this.productTier = productTier;
    return this;
  }

   /**
   * Get productTier
   * @return productTier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRODUCT_TIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductTier() {
    return productTier;
  }


  public void setProductTier(String productTier) {
    this.productTier = productTier;
  }


  public Subscription autoPay(Boolean autoPay) {
    
    this.autoPay = autoPay;
    return this;
  }

   /**
   * Get autoPay
   * @return autoPay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTO_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoPay() {
    return autoPay;
  }


  public void setAutoPay(Boolean autoPay) {
    this.autoPay = autoPay;
  }


  public Subscription paymentAmount(Double paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * Get paymentAmount
   * @return paymentAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getPaymentAmount() {
    return paymentAmount;
  }


  public void setPaymentAmount(Double paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public Subscription paymentTerm(String paymentTerm) {
    
    this.paymentTerm = paymentTerm;
    return this;
  }

   /**
   * Get paymentTerm
   * @return paymentTerm
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentTerm() {
    return paymentTerm;
  }


  public void setPaymentTerm(String paymentTerm) {
    this.paymentTerm = paymentTerm;
  }


  public Subscription paymentCurrency(String paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * Get paymentCurrency
   * @return paymentCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(String paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public Subscription id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Subscription ccLast4(String ccLast4) {
    
    this.ccLast4 = ccLast4;
    return this;
  }

   /**
   * Get ccLast4
   * @return ccLast4
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CC_LAST4)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCcLast4() {
    return ccLast4;
  }


  public void setCcLast4(String ccLast4) {
    this.ccLast4 = ccLast4;
  }


  public Subscription ccExpiration(String ccExpiration) {
    
    this.ccExpiration = ccExpiration;
    return this;
  }

   /**
   * Get ccExpiration
   * @return ccExpiration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CC_EXPIRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCcExpiration() {
    return ccExpiration;
  }


  public void setCcExpiration(String ccExpiration) {
    this.ccExpiration = ccExpiration;
  }


  public Subscription company(String company) {
    
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompany() {
    return company;
  }


  public void setCompany(String company) {
    this.company = company;
  }


  public Subscription name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public Subscription address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Get address1
   * @return address1
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public Subscription address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Get address2
   * @return address2
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public Subscription city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  public void setCity(String city) {
    this.city = city;
  }


  public Subscription state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  public void setState(String state) {
    this.state = state;
  }


  public Subscription postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Get postalCode
   * @return postalCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public Subscription country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }


  public Subscription contactPhone(String contactPhone) {
    
    this.contactPhone = contactPhone;
    return this;
  }

   /**
   * Get contactPhone
   * @return contactPhone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContactPhone() {
    return contactPhone;
  }


  public void setContactPhone(String contactPhone) {
    this.contactPhone = contactPhone;
  }


  public Subscription contactEmail(String contactEmail) {
    
    this.contactEmail = contactEmail;
    return this;
  }

   /**
   * Get contactEmail
   * @return contactEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContactEmail() {
    return contactEmail;
  }


  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }


  public Subscription modules(List<String> modules) {
    
    this.modules = modules;
    return this;
  }

  public Subscription addModulesItem(String modulesItem) {
    if (this.modules == null) {
      this.modules = new ArrayList<>();
    }
    this.modules.add(modulesItem);
    return this;
  }

   /**
   * Get modules
   * @return modules
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MODULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getModules() {
    return modules;
  }


  public void setModules(List<String> modules) {
    this.modules = modules;
  }


  public Subscription limits(Map<String, Integer> limits) {
    
    this.limits = limits;
    return this;
  }

  public Subscription putLimitsItem(String key, Integer limitsItem) {
    if (this.limits == null) {
      this.limits = new HashMap<>();
    }
    this.limits.put(key, limitsItem);
    return this;
  }

   /**
   * Get limits
   * @return limits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIMITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Integer> getLimits() {
    return limits;
  }


  public void setLimits(Map<String, Integer> limits) {
    this.limits = limits;
  }


  public Subscription discounts(List<SubscriptionDiscount> discounts) {
    
    this.discounts = discounts;
    return this;
  }

  public Subscription addDiscountsItem(SubscriptionDiscount discountsItem) {
    if (this.discounts == null) {
      this.discounts = new ArrayList<>();
    }
    this.discounts.add(discountsItem);
    return this;
  }

   /**
   * Get discounts
   * @return discounts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubscriptionDiscount> getDiscounts() {
    return discounts;
  }


  public void setDiscounts(List<SubscriptionDiscount> discounts) {
    this.discounts = discounts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Subscription subscription = (Subscription) o;
    return Objects.equals(this.paymentId, subscription.paymentId) &&
        Objects.equals(this.productId, subscription.productId) &&
        Objects.equals(this.term, subscription.term) &&
        Objects.equals(this.productName, subscription.productName) &&
        Objects.equals(this.productTier, subscription.productTier) &&
        Objects.equals(this.autoPay, subscription.autoPay) &&
        Objects.equals(this.paymentAmount, subscription.paymentAmount) &&
        Objects.equals(this.paymentTerm, subscription.paymentTerm) &&
        Objects.equals(this.paymentCurrency, subscription.paymentCurrency) &&
        Objects.equals(this.id, subscription.id) &&
        Objects.equals(this.ccLast4, subscription.ccLast4) &&
        Objects.equals(this.ccExpiration, subscription.ccExpiration) &&
        Objects.equals(this.company, subscription.company) &&
        Objects.equals(this.name, subscription.name) &&
        Objects.equals(this.address1, subscription.address1) &&
        Objects.equals(this.address2, subscription.address2) &&
        Objects.equals(this.city, subscription.city) &&
        Objects.equals(this.state, subscription.state) &&
        Objects.equals(this.postalCode, subscription.postalCode) &&
        Objects.equals(this.country, subscription.country) &&
        Objects.equals(this.contactPhone, subscription.contactPhone) &&
        Objects.equals(this.contactEmail, subscription.contactEmail) &&
        Objects.equals(this.modules, subscription.modules) &&
        Objects.equals(this.limits, subscription.limits) &&
        Objects.equals(this.discounts, subscription.discounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentId, productId, term, productName, productTier, autoPay, paymentAmount, paymentTerm, paymentCurrency, id, ccLast4, ccExpiration, company, name, address1, address2, city, state, postalCode, country, contactPhone, contactEmail, modules, limits, discounts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Subscription {\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    term: ").append(toIndentedString(term)).append("\n");
    sb.append("    productName: ").append(toIndentedString(productName)).append("\n");
    sb.append("    productTier: ").append(toIndentedString(productTier)).append("\n");
    sb.append("    autoPay: ").append(toIndentedString(autoPay)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    paymentTerm: ").append(toIndentedString(paymentTerm)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ccLast4: ").append(toIndentedString(ccLast4)).append("\n");
    sb.append("    ccExpiration: ").append(toIndentedString(ccExpiration)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    contactPhone: ").append(toIndentedString(contactPhone)).append("\n");
    sb.append("    contactEmail: ").append(toIndentedString(contactEmail)).append("\n");
    sb.append("    modules: ").append(toIndentedString(modules)).append("\n");
    sb.append("    limits: ").append(toIndentedString(limits)).append("\n");
    sb.append("    discounts: ").append(toIndentedString(discounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

