/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ScaffoldResult
 */
@JsonPropertyOrder({
  ScaffoldResult.JSON_PROPERTY_ID,
  ScaffoldResult.JSON_PROPERTY_PROJECT,
  ScaffoldResult.JSON_PROPERTY_VERSION,
  ScaffoldResult.JSON_PROPERTY_URL,
  ScaffoldResult.JSON_PROPERTY_SOURCE,
  ScaffoldResult.JSON_PROPERTY_MESSAGES
})

public class ScaffoldResult {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_MESSAGES = "messages";
  private List<String> messages = null;


  public ScaffoldResult id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Project ID
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project ID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public ScaffoldResult project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public ScaffoldResult version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Project version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public ScaffoldResult url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Project URL
   * @return url
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project URL")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


  public void setUrl(String url) {
    this.url = url;
  }


  public ScaffoldResult source(String source) {
    
    this.source = source;
    return this;
  }

   /**
   * Template Source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Template Source")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }


  public void setSource(String source) {
    this.source = source;
  }


  public ScaffoldResult messages(List<String> messages) {
    
    this.messages = messages;
    return this;
  }

  public ScaffoldResult addMessagesItem(String messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * Messages
   * @return messages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Messages")
  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMessages() {
    return messages;
  }


  public void setMessages(List<String> messages) {
    this.messages = messages;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScaffoldResult scaffoldResult = (ScaffoldResult) o;
    return Objects.equals(this.id, scaffoldResult.id) &&
        Objects.equals(this.project, scaffoldResult.project) &&
        Objects.equals(this.version, scaffoldResult.version) &&
        Objects.equals(this.url, scaffoldResult.url) &&
        Objects.equals(this.source, scaffoldResult.source) &&
        Objects.equals(this.messages, scaffoldResult.messages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, project, version, url, source, messages);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScaffoldResult {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

