/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ScaffoldRequest
 */
@JsonPropertyOrder({
  ScaffoldRequest.JSON_PROPERTY_TEMPLATE,
  ScaffoldRequest.JSON_PROPERTY_PROJECT,
  ScaffoldRequest.JSON_PROPERTY_VERSION
})

public class ScaffoldRequest {
  public static final String JSON_PROPERTY_TEMPLATE = "template";
  private String template;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;


  public ScaffoldRequest template(String template) {
    
    this.template = template;
    return this;
  }

   /**
   * Template name
   * @return template
  **/
  @ApiModelProperty(required = true, value = "Template name")
  @JsonProperty(JSON_PROPERTY_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTemplate() {
    return template;
  }


  public void setTemplate(String template) {
    this.template = template;
  }


  public ScaffoldRequest project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Target name
   * @return project
  **/
  @ApiModelProperty(required = true, value = "Target name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public ScaffoldRequest version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Target version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Target version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScaffoldRequest scaffoldRequest = (ScaffoldRequest) o;
    return Objects.equals(this.template, scaffoldRequest.template) &&
        Objects.equals(this.project, scaffoldRequest.project) &&
        Objects.equals(this.version, scaffoldRequest.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, project, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScaffoldRequest {\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

