/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.java.models.ComputeOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ProcessorRequest
 */
@JsonPropertyOrder({
  ProcessorRequest.JSON_PROPERTY_PROJECT,
  ProcessorRequest.JSON_PROPERTY_RULESET,
  ProcessorRequest.JSON_PROPERTY_VERSION,
  ProcessorRequest.JSON_PROPERTY_PROPERTIES,
  ProcessorRequest.JSON_PROPERTY_INPUTS,
  ProcessorRequest.JSON_PROPERTY_OUTPUTS,
  ProcessorRequest.JSON_PROPERTY_OPTIONS
})

public class ProcessorRequest {
  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_INPUTS = "inputs";
  private List<Map<String, Object>> inputs = null;

  public static final String JSON_PROPERTY_OUTPUTS = "outputs";
  private List<String> outputs = null;

  public static final String JSON_PROPERTY_OPTIONS = "options";
  private ComputeOptions options;


  public ProcessorRequest project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public ProcessorRequest ruleset(String ruleset) {
    
    this.ruleset = ruleset;
    return this;
  }

   /**
   * Ruleset name
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset name")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }


  public void setRuleset(String ruleset) {
    this.ruleset = ruleset;
  }


  public ProcessorRequest version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Ruleset version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public ProcessorRequest properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public ProcessorRequest putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * User properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User properties")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public ProcessorRequest inputs(List<Map<String, Object>> inputs) {
    
    this.inputs = inputs;
    return this;
  }

  public ProcessorRequest addInputsItem(Map<String, Object> inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

   /**
   * Inputs to process
   * @return inputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Inputs to process")
  @JsonProperty(JSON_PROPERTY_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Map<String, Object>> getInputs() {
    return inputs;
  }


  public void setInputs(List<Map<String, Object>> inputs) {
    this.inputs = inputs;
  }


  public ProcessorRequest outputs(List<String> outputs) {
    
    this.outputs = outputs;
    return this;
  }

  public ProcessorRequest addOutputsItem(String outputsItem) {
    if (this.outputs == null) {
      this.outputs = new ArrayList<>();
    }
    this.outputs.add(outputsItem);
    return this;
  }

   /**
   * Outputs to return (by name)
   * @return outputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Outputs to return (by name)")
  @JsonProperty(JSON_PROPERTY_OUTPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getOutputs() {
    return outputs;
  }


  public void setOutputs(List<String> outputs) {
    this.outputs = outputs;
  }


  public ProcessorRequest options(ComputeOptions options) {
    
    this.options = options;
    return this;
  }

   /**
   * Get options
   * @return options
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ComputeOptions getOptions() {
    return options;
  }


  public void setOptions(ComputeOptions options) {
    this.options = options;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessorRequest processorRequest = (ProcessorRequest) o;
    return Objects.equals(this.project, processorRequest.project) &&
        Objects.equals(this.ruleset, processorRequest.ruleset) &&
        Objects.equals(this.version, processorRequest.version) &&
        Objects.equals(this.properties, processorRequest.properties) &&
        Objects.equals(this.inputs, processorRequest.inputs) &&
        Objects.equals(this.outputs, processorRequest.outputs) &&
        Objects.equals(this.options, processorRequest.options);
  }

  @Override
  public int hashCode() {
    return Objects.hash(project, ruleset, version, properties, inputs, outputs, options);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessorRequest {\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    outputs: ").append(toIndentedString(outputs)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

