/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.java.models.Assertion;
import io.logicdrop.openapi.java.models.DesignerEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * DesignerResult
 */
@JsonPropertyOrder({
  DesignerResult.JSON_PROPERTY_TIMESTAMP,
  DesignerResult.JSON_PROPERTY_DURATION,
  DesignerResult.JSON_PROPERTY_ACTIVATIONS,
  DesignerResult.JSON_PROPERTY_EXCEPTION,
  DesignerResult.JSON_PROPERTY_ERROR,
  DesignerResult.JSON_PROPERTY_PROPERTIES,
  DesignerResult.JSON_PROPERTY_ASSERTIONS,
  DesignerResult.JSON_PROPERTY_RESULTS,
  DesignerResult.JSON_PROPERTY_DICTIONARY,
  DesignerResult.JSON_PROPERTY_MESSAGES,
  DesignerResult.JSON_PROPERTY_MATCHES,
  DesignerResult.JSON_PROPERTY_EVENTS
})

public class DesignerResult {
  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private String timestamp;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private Long duration;

  public static final String JSON_PROPERTY_ACTIVATIONS = "activations";
  private Integer activations;

  public static final String JSON_PROPERTY_EXCEPTION = "exception";
  private Boolean exception;

  public static final String JSON_PROPERTY_ERROR = "error";
  private String error;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
  private List<Assertion> assertions = null;

  public static final String JSON_PROPERTY_RESULTS = "results";
  private Map<String, Object> results = null;

  public static final String JSON_PROPERTY_DICTIONARY = "dictionary";
  private Map<String, Object> dictionary = null;

  public static final String JSON_PROPERTY_MESSAGES = "messages";
  private List<String> messages = null;

  public static final String JSON_PROPERTY_MATCHES = "matches";
  private List<String> matches = null;

  public static final String JSON_PROPERTY_EVENTS = "events";
  private List<DesignerEvent> events = null;


   /**
   * Timestamp
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timestamp")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimestamp() {
    return timestamp;
  }




   /**
   * Get duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDuration() {
    return duration;
  }




   /**
   * Get activations
   * @return activations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getActivations() {
    return activations;
  }




   /**
   * Get exception
   * @return exception
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getException() {
    return exception;
  }




   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getError() {
    return error;
  }




   /**
   * Get properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }




   /**
   * Assertion results
   * @return assertions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Assertion results")
  @JsonProperty(JSON_PROPERTY_ASSERTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Assertion> getAssertions() {
    return assertions;
  }




   /**
   * Get results
   * @return results
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getResults() {
    return results;
  }




   /**
   * Flattened data
   * @return dictionary
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Flattened data")
  @JsonProperty(JSON_PROPERTY_DICTIONARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getDictionary() {
    return dictionary;
  }




   /**
   * Get messages
   * @return messages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMessages() {
    return messages;
  }




   /**
   * Get matches
   * @return matches
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MATCHES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMatches() {
    return matches;
  }




   /**
   * Events
   * @return events
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Events")
  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DesignerEvent> getEvents() {
    return events;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DesignerResult designerResult = (DesignerResult) o;
    return Objects.equals(this.timestamp, designerResult.timestamp) &&
        Objects.equals(this.duration, designerResult.duration) &&
        Objects.equals(this.activations, designerResult.activations) &&
        Objects.equals(this.exception, designerResult.exception) &&
        Objects.equals(this.error, designerResult.error) &&
        Objects.equals(this.properties, designerResult.properties) &&
        Objects.equals(this.assertions, designerResult.assertions) &&
        Objects.equals(this.results, designerResult.results) &&
        Objects.equals(this.dictionary, designerResult.dictionary) &&
        Objects.equals(this.messages, designerResult.messages) &&
        Objects.equals(this.matches, designerResult.matches) &&
        Objects.equals(this.events, designerResult.events);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, duration, activations, exception, error, properties, assertions, results, dictionary, messages, matches, events);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DesignerResult {\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    activations: ").append(toIndentedString(activations)).append("\n");
    sb.append("    exception: ").append(toIndentedString(exception)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    assertions: ").append(toIndentedString(assertions)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("    dictionary: ").append(toIndentedString(dictionary)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    matches: ").append(toIndentedString(matches)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

