/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.logicdrop.openapi.java.models.RuleEventData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Events
 */
@ApiModel(description = "Events")
@JsonPropertyOrder({
  DesignerEvent.JSON_PROPERTY_EVENT,
  DesignerEvent.JSON_PROPERTY_TYPE,
  DesignerEvent.JSON_PROPERTY_MESSAGE,
  DesignerEvent.JSON_PROPERTY_RULE,
  DesignerEvent.JSON_PROPERTY_PATH,
  DesignerEvent.JSON_PROPERTY_NAME,
  DesignerEvent.JSON_PROPERTY_SOURCE,
  DesignerEvent.JSON_PROPERTY_ROW,
  DesignerEvent.JSON_PROPERTY_ID,
  DesignerEvent.JSON_PROPERTY_TIMESTAMP,
  DesignerEvent.JSON_PROPERTY_TRIGGERS,
  DesignerEvent.JSON_PROPERTY_CURRENT,
  DesignerEvent.JSON_PROPERTY_PREVIOUS
})

public class DesignerEvent {
  /**
   * Event type
   */
  public enum EventEnum {
    INSERT("INSERT"),
    
    DELETE("DELETE"),
    
    UPDATE("UPDATE"),
    
    BEFORE_MATCH("BEFORE_MATCH"),
    
    AFTER_MATCH("AFTER_MATCH"),
    
    MATCH_CREATED("MATCH_CREATED"),
    
    MATCH_CANCELLED("MATCH_CANCELLED");

    private String value;

    EventEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventEnum fromValue(String value) {
      for (EventEnum b : EventEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT = "event";
  private EventEnum event;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_RULE = "rule";
  private String rule;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_ROW = "row";
  private Integer row;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp;

  public static final String JSON_PROPERTY_TRIGGERS = "triggers";
  private List<Object> triggers = null;

  public static final String JSON_PROPERTY_CURRENT = "current";
  private RuleEventData current;

  public static final String JSON_PROPERTY_PREVIOUS = "previous";
  private RuleEventData previous;


   /**
   * Event type
   * @return event
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Event type")
  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EventEnum getEvent() {
    return event;
  }




   /**
   * Rule type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule type")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }




   /**
   * Event message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Event message")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }




   /**
   * Rule name
   * @return rule
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule name")
  @JsonProperty(JSON_PROPERTY_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRule() {
    return rule;
  }




   /**
   * Rule path
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule path")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }




   /**
   * User rule name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User rule name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }




   /**
   * User rule source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User rule source")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }




   /**
   * User rule row (if applicable)
   * @return row
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User rule row (if applicable)")
  @JsonProperty(JSON_PROPERTY_ROW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRow() {
    return row;
  }




   /**
   * Rule Id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rule Id")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }




   /**
   * Timestamp
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timestamp")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimestamp() {
    return timestamp;
  }




   /**
   * Match triggers
   * @return triggers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match triggers")
  @JsonProperty(JSON_PROPERTY_TRIGGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getTriggers() {
    return triggers;
  }




  public DesignerEvent current(RuleEventData current) {
    
    this.current = current;
    return this;
  }

   /**
   * Get current
   * @return current
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CURRENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RuleEventData getCurrent() {
    return current;
  }


  public void setCurrent(RuleEventData current) {
    this.current = current;
  }


  public DesignerEvent previous(RuleEventData previous) {
    
    this.previous = previous;
    return this;
  }

   /**
   * Get previous
   * @return previous
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RuleEventData getPrevious() {
    return previous;
  }


  public void setPrevious(RuleEventData previous) {
    this.previous = previous;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DesignerEvent designerEvent = (DesignerEvent) o;
    return Objects.equals(this.event, designerEvent.event) &&
        Objects.equals(this.type, designerEvent.type) &&
        Objects.equals(this.message, designerEvent.message) &&
        Objects.equals(this.rule, designerEvent.rule) &&
        Objects.equals(this.path, designerEvent.path) &&
        Objects.equals(this.name, designerEvent.name) &&
        Objects.equals(this.source, designerEvent.source) &&
        Objects.equals(this.row, designerEvent.row) &&
        Objects.equals(this.id, designerEvent.id) &&
        Objects.equals(this.timestamp, designerEvent.timestamp) &&
        Objects.equals(this.triggers, designerEvent.triggers) &&
        Objects.equals(this.current, designerEvent.current) &&
        Objects.equals(this.previous, designerEvent.previous);
  }

  @Override
  public int hashCode() {
    return Objects.hash(event, type, message, rule, path, name, source, row, id, timestamp, triggers, current, previous);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DesignerEvent {\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    rule: ").append(toIndentedString(rule)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    triggers: ").append(toIndentedString(triggers)).append("\n");
    sb.append("    current: ").append(toIndentedString(current)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

