/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.java.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Processor options
 */
@ApiModel(description = "Processor options")
@JsonPropertyOrder({
  ComputeOptions.JSON_PROPERTY_DEBUG,
  ComputeOptions.JSON_PROPERTY_THRESHOLD
})

public class ComputeOptions {
  public static final String JSON_PROPERTY_DEBUG = "debug";
  private Boolean debug = false;

  public static final String JSON_PROPERTY_THRESHOLD = "threshold";
  private Integer threshold = 1000;


  public ComputeOptions debug(Boolean debug) {
    
    this.debug = debug;
    return this;
  }

   /**
   * Enable debugging?
   * @return debug
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Enable debugging?")
  @JsonProperty(JSON_PROPERTY_DEBUG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDebug() {
    return debug;
  }


  public void setDebug(Boolean debug) {
    this.debug = debug;
  }


  public ComputeOptions threshold(Integer threshold) {
    
    this.threshold = threshold;
    return this;
  }

   /**
   * Maximum rules to fire
   * @return threshold
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Maximum rules to fire")
  @JsonProperty(JSON_PROPERTY_THRESHOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getThreshold() {
    return threshold;
  }


  public void setThreshold(Integer threshold) {
    this.threshold = threshold;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ComputeOptions computeOptions = (ComputeOptions) o;
    return Objects.equals(this.debug, computeOptions.debug) &&
        Objects.equals(this.threshold, computeOptions.threshold);
  }

  @Override
  public int hashCode() {
    return Objects.hash(debug, threshold);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ComputeOptions {\n");
    sb.append("    debug: ").append(toIndentedString(debug)).append("\n");
    sb.append("    threshold: ").append(toIndentedString(threshold)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

