/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.core.typeconverters;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.logansquarex.core.typeconverters.TypeConverter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;

public abstract class CalendarTypeConverter
implements TypeConverter<Calendar> {
    private final ThreadLocal<DateFormat> mDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return CalendarTypeConverter.this.getDateFormat();
        }
    };

    @Override
    public Calendar parse(JsonParser jsonParser) throws IOException {
        String dateString = jsonParser.getValueAsString(null);
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.mDateFormat.get().parse(dateString));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public void serialize(Calendar object, String fieldName, boolean writeFieldNameForObject, JsonGenerator jsonGenerator) throws IOException {
        if (fieldName != null) {
            jsonGenerator.writeStringField(fieldName, this.mDateFormat.get().format(object.getTimeInMillis()));
        } else {
            jsonGenerator.writeString(this.mDateFormat.get().format(object.getTimeInMillis()));
        }
    }

    public abstract DateFormat getDateFormat();
}

