/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.core;

import com.fasterxml.jackson.core.JsonFactory;
import io.logansquarex.core.JsonMapper;
import io.logansquarex.core.NoSuchMapperException;
import io.logansquarex.core.NoSuchTypeConverterException;
import io.logansquarex.core.ParameterizedType;
import io.logansquarex.core.objectmappers.BooleanMapper;
import io.logansquarex.core.objectmappers.DoubleMapper;
import io.logansquarex.core.objectmappers.FloatMapper;
import io.logansquarex.core.objectmappers.IntegerMapper;
import io.logansquarex.core.objectmappers.ListMapper;
import io.logansquarex.core.objectmappers.LongMapper;
import io.logansquarex.core.objectmappers.MapMapper;
import io.logansquarex.core.objectmappers.ObjectMapper;
import io.logansquarex.core.objectmappers.StringMapper;
import io.logansquarex.core.typeconverters.DefaultCalendarConverter;
import io.logansquarex.core.typeconverters.DefaultDateConverter;
import io.logansquarex.core.typeconverters.TypeConverter;
import io.logansquarex.core.util.SimpleArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoganSquare {
    private static final ListMapper LIST_MAPPER = new ListMapper();
    private static final MapMapper MAP_MAPPER = new MapMapper();
    private static final Map<Class, JsonMapper> OBJECT_MAPPERS = new ConcurrentHashMap<Class, JsonMapper>();
    private static final ConcurrentHashMap<ParameterizedType, JsonMapper> PARAMETERIZED_OBJECT_MAPPERS;
    private static final SimpleArrayMap<Class, TypeConverter> TYPE_CONVERTERS;
    public static final JsonFactory JSON_FACTORY;

    public static <E> E parse(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parse(is);
    }

    public static <E> E parse(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parse(jsonString);
    }

    public static <E> E parse(InputStream is, ParameterizedType<E> jsonObjectType) throws IOException {
        return LoganSquare.mapperFor(jsonObjectType).parse(is);
    }

    public static <E> E parse(String jsonString, ParameterizedType<E> jsonObjectType) throws IOException {
        return LoganSquare.mapperFor(jsonObjectType).parse(jsonString);
    }

    public static <E> List<E> parseList(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseList(is);
    }

    public static <E> List<E> parseList(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseList(jsonString);
    }

    public static <E> Map<String, E> parseMap(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseMap(is);
    }

    public static <E> Map<String, E> parseMap(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseMap(jsonString);
    }

    public static <E> String serialize(E object) throws IOException {
        return LoganSquare.mapperFor(object.getClass()).serialize(object);
    }

    public static <E> void serialize(E object, OutputStream os) throws IOException {
        LoganSquare.mapperFor(object.getClass()).serialize(object, os);
    }

    public static <E> String serialize(E object, ParameterizedType<E> parameterizedType) throws IOException {
        return LoganSquare.mapperFor(parameterizedType).serialize(object);
    }

    public static <E> void serialize(E object, ParameterizedType<E> parameterizedType, OutputStream os) throws IOException {
        LoganSquare.mapperFor(parameterizedType).serialize(object, os);
    }

    public static <E> String serialize(List<E> list, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).serialize(list);
    }

    public static <E> void serialize(List<E> list, OutputStream os, Class<E> jsonObjectClass) throws IOException {
        LoganSquare.mapperFor(jsonObjectClass).serialize(list, os);
    }

    public static <E> String serialize(Map<String, E> map, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).serialize(map);
    }

    public static <E> void serialize(Map<String, E> map, OutputStream os, Class<E> jsonObjectClass) throws IOException {
        LoganSquare.mapperFor(jsonObjectClass).serialize(map, os);
    }

    static <E> JsonMapper<E> getMapper(Class<E> cls) {
        JsonMapper mapper = OBJECT_MAPPERS.get(cls);
        if (mapper == null) {
            try {
                Class<?> mapperClass = Class.forName(cls.getName() + "$$JsonObjectMapper");
                mapper = (JsonMapper)mapperClass.newInstance();
                OBJECT_MAPPERS.put(cls, mapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapper;
    }

    private static <E> JsonMapper<E> getMapper(ParameterizedType<E> type, SimpleArrayMap<ParameterizedType, JsonMapper> partialMappers) {
        if (type.typeParameters.size() == 0) {
            return LoganSquare.getMapper(type.rawType);
        }
        if (partialMappers == null) {
            partialMappers = new SimpleArrayMap();
        }
        if (partialMappers.containsKey(type)) {
            return partialMappers.get(type);
        }
        if (PARAMETERIZED_OBJECT_MAPPERS.containsKey(type)) {
            return PARAMETERIZED_OBJECT_MAPPERS.get(type);
        }
        try {
            Class<?> mapperClass = Class.forName(type.rawType.getName() + "$$JsonObjectMapper");
            Constructor<?> constructor = mapperClass.getDeclaredConstructors()[0];
            Object[] args = new Object[2 + type.typeParameters.size()];
            args[0] = type;
            args[args.length - 1] = partialMappers;
            for (int i = 0; i < type.typeParameters.size(); ++i) {
                args[i + 1] = type.typeParameters.get(i);
            }
            JsonMapper mapper = (JsonMapper)constructor.newInstance(args);
            PARAMETERIZED_OBJECT_MAPPERS.put(type, mapper);
            return mapper;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean supports(Class cls) {
        return LoganSquare.getMapper(cls) != null;
    }

    public static boolean supports(ParameterizedType type) {
        return LoganSquare.getMapper(type, null) != null;
    }

    public static <E> JsonMapper<E> mapperFor(Class<E> cls) throws NoSuchMapperException {
        JsonMapper<E> mapper = LoganSquare.getMapper(cls);
        if (mapper == null) {
            throw new NoSuchMapperException(cls);
        }
        return mapper;
    }

    public static <E> JsonMapper<E> mapperFor(ParameterizedType<E> type) throws NoSuchMapperException {
        return LoganSquare.mapperFor(type, null);
    }

    public static <E> JsonMapper<E> mapperFor(ParameterizedType<E> type, SimpleArrayMap<ParameterizedType, JsonMapper> partialMappers) throws NoSuchMapperException {
        JsonMapper<E> mapper = LoganSquare.getMapper(type, partialMappers);
        if (mapper == null) {
            throw new NoSuchMapperException(type.rawType);
        }
        return mapper;
    }

    public static <E> TypeConverter<E> typeConverterFor(Class<E> cls) throws NoSuchTypeConverterException {
        TypeConverter typeConverter = TYPE_CONVERTERS.get(cls);
        if (typeConverter == null) {
            throw new NoSuchTypeConverterException(cls);
        }
        return typeConverter;
    }

    public static <E> void registerTypeConverter(Class<E> cls, TypeConverter<E> converter) {
        TYPE_CONVERTERS.put(cls, converter);
    }

    static {
        OBJECT_MAPPERS.put(String.class, new StringMapper());
        OBJECT_MAPPERS.put(Integer.class, new IntegerMapper());
        OBJECT_MAPPERS.put(Long.class, new LongMapper());
        OBJECT_MAPPERS.put(Float.class, new FloatMapper());
        OBJECT_MAPPERS.put(Double.class, new DoubleMapper());
        OBJECT_MAPPERS.put(Boolean.class, new BooleanMapper());
        OBJECT_MAPPERS.put(Object.class, new ObjectMapper());
        OBJECT_MAPPERS.put(List.class, LIST_MAPPER);
        OBJECT_MAPPERS.put(ArrayList.class, LIST_MAPPER);
        OBJECT_MAPPERS.put(Map.class, MAP_MAPPER);
        OBJECT_MAPPERS.put(HashMap.class, MAP_MAPPER);
        PARAMETERIZED_OBJECT_MAPPERS = new ConcurrentHashMap();
        TYPE_CONVERTERS = new SimpleArrayMap();
        LoganSquare.registerTypeConverter(Date.class, new DefaultDateConverter());
        LoganSquare.registerTypeConverter(Calendar.class, new DefaultCalendarConverter());
        JSON_FACTORY = new JsonFactory();
    }
}

